/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import net.tomp2p.message.MessageCodec;
import net.tomp2p.message.ProtocolChunked;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;
import org.jboss.netty.buffer.ChannelBuffer;

public class DataCodec {
    public static int encodeData(ProtocolChunked input, Data data) throws ClassNotFoundException, IOException {
        int count = 8;
        int seconds = data.getTTLSeconds();
        seconds = data.isProtectedEntry() ? seconds | Integer.MIN_VALUE : seconds & Integer.MAX_VALUE;
        seconds = data.isFileReference() ? seconds | 0x40000000 : seconds & 0xBFFFFFFF;
        input.copyToCurrent(seconds);
        if (data.isFileReference()) {
            File file = (File)data.getObject();
            long len = file.length();
            input.copyToCurrent((int)len);
            FileInputStream inFile = new FileInputStream(file);
            FileChannel inChannel = inFile.getChannel();
            input.transferToCurrent(inChannel, file.length());
            count = (int)((long)count + len);
        } else {
            input.copyToCurrent(data.getLength());
            input.copyToCurrent(data.getData(), data.getOffset(), data.getLength());
            count += data.getLength();
        }
        return count;
    }

    public static Data decodeData(ChannelBuffer buffer, PeerAddress originator) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        if (buffer.readableBytes() < 8) {
            return null;
        }
        int ttl = buffer.readInt();
        boolean protectedEntry = (ttl & Integer.MIN_VALUE) != 0;
        boolean fileReference = (ttl & 0x40000000) != 0;
        ttl &= 0x3FFFFFFF;
        int dateLength = buffer.readInt();
        if (buffer.readableBytes() < dateLength) {
            return null;
        }
        ByteBuffer[] byteBuffers = buffer.toByteBuffers(buffer.readerIndex(), dateLength);
        Data data = DataCodec.createData(byteBuffers, dateLength, ttl, protectedEntry, fileReference, originator);
        buffer.skipBytes(dateLength);
        return data;
    }

    public static Data createData(ByteBuffer[] byteBuffers, int length, int ttl, boolean protectedEntry, boolean fileReference, PeerAddress originator) {
        Data data = length == 0 ? new Data(MessageCodec.EMPTY_BYTE_ARRAY, originator.getID()) : new Data(byteBuffers, length, originator.getID());
        return data.setTTLSeconds(ttl).setProtectedEntry(protectedEntry).setFileReference(fileReference);
    }
}

