/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.tomp2p.message.ProtocolChunked;
import net.tomp2p.message.SHA1Signature;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.DefaultFileRegion;
import org.jboss.netty.handler.stream.ChunkedInput;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;

public class ProtocolChunkedInput
implements ChunkedInput,
ProtocolChunked {
    private final ChannelHandlerContext ctx;
    private final Queue<Object> queue = new ConcurrentLinkedQueue<Object>();
    private ChannelBuffer channelBuffer = ChannelBuffers.dynamicBuffer();
    private volatile boolean done = false;
    private final Signature signature;

    public ProtocolChunkedInput(ChannelHandlerContext ctx, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException {
        this.ctx = ctx;
        if (privateKey != null) {
            this.signature = Signature.getInstance("SHA1withDSA");
            this.signature.initSign(privateKey);
        } else {
            this.signature = null;
        }
    }

    public boolean hasNextChunk() throws Exception {
        return !this.queue.isEmpty();
    }

    public Object nextChunk() throws Exception {
        Object object = this.queue.poll();
        if (object == null) {
            return null;
        }
        if (object instanceof ChannelBuffer) {
            ChannelBuffer channelBuffer = (ChannelBuffer)object;
            if (this.signature != null && channelBuffer != ChannelBuffers.EMPTY_BUFFER) {
                ByteBuffer[] tmp = channelBuffer.duplicate().toByteBuffers();
                for (int i = 0; i < tmp.length; ++i) {
                    this.signature.update(tmp[i]);
                }
            } else if (this.signature != null && channelBuffer == ChannelBuffers.EMPTY_BUFFER) {
                byte[] signatureData = this.signature.sign();
                SHA1Signature decodedSignature = new SHA1Signature();
                decodedSignature.decode(signatureData);
                channelBuffer = ChannelBuffers.wrappedBuffer((byte[][])new byte[][]{decodedSignature.getNumber1().toByteArray(), decodedSignature.getNumber2().toByteArray()});
            }
            return channelBuffer;
        }
        if (object instanceof DefaultFileRegion) {
            DefaultFileRegion fileRegion = (DefaultFileRegion)object;
            if (this.signature != null) {
                // empty if block
            }
            return fileRegion;
        }
        throw new RuntimeException("unknown object");
    }

    public int size() {
        return this.queue.size();
    }

    public void addMarkerForSignature() {
        this.flush(true);
        this.queue.add(ChannelBuffers.EMPTY_BUFFER);
        this.done = true;
    }

    public boolean isEndOfInput() throws Exception {
        return this.done && !this.hasNextChunk();
    }

    public void close() throws Exception {
        this.done = true;
    }

    public void resume() {
        ChunkedWriteHandler chunkedWriteHandler = (ChunkedWriteHandler)this.ctx.getPipeline().get("streamer");
        chunkedWriteHandler.resumeTransfer();
    }

    @Override
    public void copyToCurrent(byte[] byteArray) {
        if (this.done) {
            return;
        }
        this.channelBuffer.writeBytes(byteArray);
    }

    @Override
    public void copyToCurrent(int size) {
        if (this.done) {
            return;
        }
        this.channelBuffer.writeInt(size);
    }

    @Override
    public void copyToCurrent(byte size) {
        if (this.done) {
            return;
        }
        this.channelBuffer.writeByte((int)size);
    }

    @Override
    public void copyToCurrent(long long1) {
        if (this.done) {
            return;
        }
        this.channelBuffer.writeLong(long1);
    }

    @Override
    public void copyToCurrent(short short1) {
        if (this.done) {
            return;
        }
        this.channelBuffer.writeShort((int)short1);
    }

    @Override
    public void copyToCurrent(ChannelBuffer slice) {
        if (this.done) {
            return;
        }
        if (slice.writerIndex() == 0) {
            return;
        }
        this.flush(false);
        this.queue.add(slice);
    }

    @Override
    public void copyToCurrent(byte[] array, int offset, int length) {
        if (this.done) {
            return;
        }
        if (length == 0) {
            return;
        }
        this.flush(false);
        this.queue.add(ChannelBuffers.wrappedBuffer((byte[])array, (int)offset, (int)length));
    }

    public void flush(boolean last) {
        if (this.channelBuffer.writerIndex() > 0) {
            this.queue.add(this.channelBuffer);
            if (!last) {
                this.channelBuffer = ChannelBuffers.dynamicBuffer();
            }
        }
        if (last) {
            this.done = true;
        }
    }

    @Override
    public void transferToCurrent(FileChannel inChannel, long length) throws IOException {
        if (this.done) {
            return;
        }
        if (length == 0L) {
            return;
        }
        this.flush(false);
        DefaultFileRegion defaultFileRegion = new DefaultFileRegion(inChannel, 0L, length);
        this.queue.add(defaultFileRegion);
    }
}

