/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.Signature;
import net.tomp2p.message.DecoderException;
import net.tomp2p.message.Message;
import net.tomp2p.message.MessageCodec;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomP2PDecoderTCP
extends FrameDecoder {
    private static final Logger logger = LoggerFactory.getLogger(TomP2PDecoderTCP.class);
    private final int maxMessageSize;
    private volatile Message message = null;
    private volatile byte[] rawHeader = new byte[56];
    private volatile Signature signature = null;
    private volatile int step = 0;

    public TomP2PDecoderTCP() {
        this(Integer.MAX_VALUE);
    }

    public TomP2PDecoderTCP(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() > this.maxMessageSize) {
            throw new DecoderException("Message size larger than " + this.maxMessageSize);
        }
        if (this.message == null && buffer.readableBytes() >= 56) {
            buffer.getBytes(buffer.readerIndex(), this.rawHeader);
            InetSocketAddress remoteSocket = (InetSocketAddress)channel.getRemoteAddress();
            InetSocketAddress localSocket = (InetSocketAddress)channel.getLocalAddress();
            this.message = MessageCodec.decodeHeader(buffer, localSocket, remoteSocket);
            if (logger.isDebugEnabled()) {
                logger.debug("got header in decoder " + this.message);
            }
            if (!this.message.hasContent()) {
                return this.cleanupAndReturnMessage();
            }
        }
        if (this.message != null && this.message.hasContent()) {
            int i;
            ByteBuffer[] tmp;
            int readerIndex = buffer.readerIndex();
            if (this.step == 0 && !MessageCodec.decodePayload(this.message.getContentType1(), buffer, this.message)) {
                buffer.readerIndex(readerIndex);
                return null;
            }
            if (this.step == 0) {
                ++this.step;
                if (this.message.isHintSign()) {
                    this.signature = Signature.getInstance("SHA1withDSA");
                    this.signature.initVerify(this.message.getPublicKey());
                    this.signature.update(this.rawHeader);
                    int read = buffer.readerIndex() - readerIndex;
                    if (read > 0) {
                        tmp = buffer.toByteBuffers(readerIndex, read);
                        for (i = 0; i < tmp.length; ++i) {
                            this.signature.update(tmp[i]);
                        }
                    }
                }
                readerIndex = buffer.readerIndex();
            }
            if (this.step == 1 && !MessageCodec.decodePayload(this.message.getContentType2(), buffer, this.message)) {
                buffer.readerIndex(readerIndex);
                return null;
            }
            if (this.step == 1) {
                int read;
                ++this.step;
                if (this.signature != null && (read = buffer.readerIndex() - readerIndex) > 0) {
                    tmp = buffer.toByteBuffers(readerIndex, read);
                    for (i = 0; i < tmp.length; ++i) {
                        this.signature.update(tmp[i]);
                    }
                }
                readerIndex = buffer.readerIndex();
            }
            if (this.step == 2 && !MessageCodec.decodePayload(this.message.getContentType3(), buffer, this.message)) {
                buffer.readerIndex(readerIndex);
                return null;
            }
            if (this.step == 2) {
                int read;
                ++this.step;
                if (this.signature != null && (read = buffer.readerIndex() - readerIndex) > 0) {
                    tmp = buffer.toByteBuffers(readerIndex, read);
                    for (i = 0; i < tmp.length; ++i) {
                        this.signature.update(tmp[i]);
                    }
                }
                readerIndex = buffer.readerIndex();
            }
            if (this.step == 3 && !MessageCodec.decodePayload(this.message.getContentType4(), buffer, this.message)) {
                buffer.readerIndex(readerIndex);
                return null;
            }
            if (this.step == 3) {
                int read;
                ++this.step;
                if (this.signature != null && (read = buffer.readerIndex() - readerIndex) > 0) {
                    tmp = buffer.toByteBuffers(readerIndex, read);
                    for (i = 0; i < tmp.length; ++i) {
                        this.signature.update(tmp[i]);
                    }
                }
                readerIndex = buffer.readerIndex();
            }
            if (this.step == 4 && this.signature != null && !MessageCodec.decodeSignature(this.signature, this.message, buffer)) {
                buffer.readerIndex(readerIndex);
                return null;
            }
            return this.cleanupAndReturnMessage();
        }
        return null;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (logger.isDebugEnabled()) {
            e.getCause().printStackTrace();
        }
        ctx.sendUpstream((ChannelEvent)e);
    }

    private Message cleanupAndReturnMessage() {
        Message tmp = this.message;
        this.message = null;
        this.step = 0;
        this.signature = null;
        if (logger.isDebugEnabled()) {
            logger.debug("cleanupAndReturnMessage " + tmp);
        }
        tmp.setTCP();
        tmp.finished();
        return tmp;
    }
}

