/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.util.ArrayList;
import java.util.Collection;
import net.tomp2p.futures.FutureDHT;
import net.tomp2p.p2p.EvaluatingSchemeDHT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.VotingSchemeDHT;
import net.tomp2p.p2p.builder.DHTBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.rpc.SimpleBloomFilter;

public class GetBuilder
extends DHTBuilder<GetBuilder> {
    private static final Collection<Number160> NUMBER_ZERO_CONTENT_KEYS = new ArrayList<Number160>(1);
    private static final FutureDHT FUTURE_DHT_MESSAGE_TOO_LARGE = (FutureDHT)new FutureDHT().setFailed("Message size exceeds UDP transfer size, please consider using TCP");
    private Collection<Number160> contentKeys;
    private Number160 contentKey;
    private SimpleBloomFilter<Number160> keyBloomFilter;
    private SimpleBloomFilter<Number160> valueBloomFilter;
    private EvaluatingSchemeDHT evaluationScheme;
    private boolean all = false;
    private boolean digest = false;
    private boolean returnBloomFilter = false;
    private boolean range = false;

    public GetBuilder(Peer peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    public Collection<Number160> getContentKeys() {
        return this.contentKeys;
    }

    public GetBuilder setContentKeys(Collection<Number160> contentKeys) {
        this.contentKeys = contentKeys;
        return this;
    }

    public Number160 getContentKey() {
        return this.contentKey;
    }

    public GetBuilder setContentKey(Number160 contentKey) {
        this.contentKey = contentKey;
        return this;
    }

    public SimpleBloomFilter<Number160> getKeyBloomFilter() {
        return this.keyBloomFilter;
    }

    public GetBuilder setKeyBloomFilter(SimpleBloomFilter<Number160> keyBloomFilter) {
        this.keyBloomFilter = keyBloomFilter;
        return this;
    }

    public SimpleBloomFilter<Number160> getValueBloomFilter() {
        return this.valueBloomFilter;
    }

    public GetBuilder setValueBloomFilter(SimpleBloomFilter<Number160> valueBloomFilter) {
        this.valueBloomFilter = valueBloomFilter;
        return this;
    }

    public EvaluatingSchemeDHT getEvaluationScheme() {
        return this.evaluationScheme;
    }

    public GetBuilder setEvaluationScheme(EvaluatingSchemeDHT evaluationScheme) {
        this.evaluationScheme = evaluationScheme;
        return this;
    }

    public boolean isAll() {
        return this.all;
    }

    public GetBuilder setAll(boolean all) {
        this.all = all;
        return this;
    }

    public GetBuilder setAll() {
        this.all = true;
        return this;
    }

    public boolean isDigest() {
        return this.digest;
    }

    public GetBuilder setDigest(boolean digest) {
        this.digest = digest;
        return this;
    }

    public GetBuilder setDigest() {
        this.digest = true;
        return this;
    }

    public boolean isReturnBloomFilter() {
        return this.returnBloomFilter;
    }

    public GetBuilder setReturnBloomFilter(boolean returnBloomFilter) {
        this.returnBloomFilter = returnBloomFilter;
        return this;
    }

    public GetBuilder setReturnBloomFilter() {
        this.returnBloomFilter = true;
        return this;
    }

    public boolean isRange() {
        return this.range;
    }

    public GetBuilder setRange(boolean range) {
        this.range = range;
        return this;
    }

    public GetBuilder setRange() {
        this.range = true;
        return this;
    }

    @Override
    public GetBuilder setRefreshSeconds(int refreshSeconds) {
        throw new UnsupportedOperationException("The get() does not have a refresh");
    }

    @Override
    public FutureDHT start() {
        if (this.peer.isShutdown()) {
            return FUTURE_DHT_SHUTDOWN;
        }
        this.preBuild("get-builder");
        if (this.all) {
            this.contentKeys = null;
        } else if (this.contentKeys == null && !this.all) {
            if (this.contentKey == null) {
                this.contentKeys = NUMBER_ZERO_CONTENT_KEYS;
            } else {
                this.contentKeys = new ArrayList<Number160>(1);
                this.contentKeys.add(this.contentKey);
            }
        } else if (this.isMessageTooLargeForUDP() && !this.routingConfiguration.isForceTCP()) {
            return FUTURE_DHT_MESSAGE_TOO_LARGE;
        }
        if (this.evaluationScheme == null) {
            this.evaluationScheme = new VotingSchemeDHT();
        }
        return this.peer.getDistributedHashMap().get(this.locationKey, this.domainKey, this.contentKeys, this.keyBloomFilter, this.valueBloomFilter, this.routingConfiguration, this.requestP2PConfiguration, this.evaluationScheme, this.signMessage, this.digest, this.returnBloomFilter, this.range, this.manualCleanup, this.futureChannelCreator, this.peer.getConnectionBean().getConnectionReservation());
    }

    public boolean isMessageTooLargeForUDP() {
        return 60 + 20 * this.contentKeys.size() > 1400;
    }

    static {
        NUMBER_ZERO_CONTENT_KEYS.add(Number160.ZERO);
    }
}

