/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.util.NavigableSet;
import java.util.TreeSet;
import net.tomp2p.futures.FutureDHT;
import net.tomp2p.p2p.DistributedHashTable;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.DHTBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;

public class ParallelRequestBuilder
extends DHTBuilder<ParallelRequestBuilder> {
    private NavigableSet<PeerAddress> queue;
    private DistributedHashTable.Operation operation;
    private boolean cancelOnFinish = false;

    public ParallelRequestBuilder(Peer peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    public NavigableSet<PeerAddress> getQueue() {
        return this.queue;
    }

    public ParallelRequestBuilder setQueue(NavigableSet<PeerAddress> queue) {
        this.queue = queue;
        return this;
    }

    public ParallelRequestBuilder add(PeerAddress peerAddress) {
        if (this.queue == null) {
            this.queue = new TreeSet<PeerAddress>(this.peer.getPeerBean().getPeerMap().createPeerComparator());
        }
        this.queue.add(peerAddress);
        return this;
    }

    public DistributedHashTable.Operation getOperation() {
        return this.operation;
    }

    public ParallelRequestBuilder setOperation(DistributedHashTable.Operation operation) {
        this.operation = operation;
        return this;
    }

    public boolean isCancelOnFinish() {
        return this.cancelOnFinish;
    }

    public ParallelRequestBuilder setCancelOnFinish() {
        this.cancelOnFinish = true;
        return this;
    }

    public ParallelRequestBuilder setCancelOnFinish(boolean cancelOnFinish) {
        this.cancelOnFinish = cancelOnFinish;
        return this;
    }

    @Override
    public FutureDHT start() {
        if (this.peer.isShutdown()) {
            return FUTURE_DHT_SHUTDOWN;
        }
        this.preBuild("parallel-builder");
        if (this.queue == null || this.queue.size() == 0) {
            throw new IllegalArgumentException("queue cannot be empty");
        }
        return this.peer.getDistributedHashMap().parallelRequests(this.requestP2PConfiguration, this.queue, this.cancelOnFinish, this.futureChannelCreator, this.peer.getConnectionBean().getConnectionReservation(), this.manualCleanup, this.operation);
    }
}

