/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureLateJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureWrapper;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import net.tomp2p.utils.Utils;

public class PingBuilder {
    private static final BaseFuture FUTURE_PING_SHUTDOWN = new FutureWrapper().setFailed("Peer is shutting down");
    private final Peer peer;
    private PeerAddress peerAddress;
    private InetAddress inetAddress;
    private int port = 7700;
    private boolean broadcast = false;
    private boolean tcpPing = false;

    public PingBuilder(Peer peer) {
        this.peer = peer;
    }

    public PeerAddress getPeerAddress() {
        return this.peerAddress;
    }

    public PingBuilder setPeerAddress(PeerAddress peerAddress) {
        this.peerAddress = peerAddress;
        return this;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public PingBuilder setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public PingBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public PingBuilder setBroadcast() {
        this.broadcast = true;
        return this;
    }

    public PingBuilder setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
        return this;
    }

    public boolean isTcpPing() {
        return this.tcpPing;
    }

    public PingBuilder setTcpPing() {
        this.tcpPing = true;
        return this;
    }

    public PingBuilder setTcpPing(boolean tcpPing) {
        this.tcpPing = tcpPing;
        return this;
    }

    public BaseFuture start() {
        if (this.peer.isShutdown()) {
            return FUTURE_PING_SHUTDOWN;
        }
        if (this.broadcast) {
            return this.pingBroadcast(this.port);
        }
        if (this.peerAddress != null) {
            if (this.tcpPing) {
                return this.ping(this.peerAddress.createSocketTCP(), true);
            }
            return this.ping(this.peerAddress.createSocketUDP(), false);
        }
        if (this.inetAddress != null) {
            if (this.tcpPing) {
                return this.ping(new InetSocketAddress(this.inetAddress, this.port), true);
            }
            return this.ping(new InetSocketAddress(this.inetAddress, this.port), false);
        }
        throw new IllegalArgumentException("cannot ping, need to know peer address or inet address");
    }

    FutureLateJoin<FutureResponse> pingBroadcast(final int port) {
        final int size = this.peer.getBindings().getBroadcastAddresses().size();
        final FutureLateJoin<FutureResponse> futureLateJoin = new FutureLateJoin<FutureResponse>(size, 1);
        if (size > 0) {
            this.peer.getConnectionBean().getConnectionReservation().reserve(size).addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                @Override
                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        for (int i = 0; i < size; ++i) {
                            InetAddress broadcastAddress = PingBuilder.this.peer.getBindings().getBroadcastAddresses().get(i);
                            PeerAddress peerAddress = new PeerAddress(Number160.ZERO, broadcastAddress, port, port);
                            FutureResponse validBroadcast = PingBuilder.this.peer.getHandshakeRPC().pingBroadcastUDP(peerAddress, future.getChannelCreator());
                            Utils.addReleaseListener(validBroadcast, PingBuilder.this.peer.getConnectionBean().getConnectionReservation(), future.getChannelCreator(), 1);
                            if (futureLateJoin.add(validBroadcast)) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        futureLateJoin.setFailed(future);
                    }
                }
            });
        } else {
            futureLateJoin.setFailed("No broadcast address found. Cannot ping nothing");
        }
        return futureLateJoin;
    }

    public FutureResponse ping(InetSocketAddress address) {
        return this.ping(address, true);
    }

    public FutureResponse ping(InetSocketAddress address, boolean isUDP) {
        if (isUDP) {
            final RequestHandlerUDP<FutureResponse> request = this.peer.getHandshakeRPC().pingUDP(new PeerAddress(Number160.ZERO, address));
            this.peer.getConnectionBean().getConnectionReservation().reserve(1).addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                @Override
                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        Object futureResponse = request.sendUDP(future.getChannelCreator());
                        Utils.addReleaseListener(futureResponse, PingBuilder.this.peer.getConnectionBean().getConnectionReservation(), future.getChannelCreator(), 1);
                    } else {
                        ((BaseFutureImpl)request.getFutureResponse()).setFailed(future);
                    }
                }
            });
            return request.getFutureResponse();
        }
        final RequestHandlerTCP<FutureResponse> request = this.peer.getHandshakeRPC().pingTCP(new PeerAddress(Number160.ZERO, address));
        this.peer.getConnectionBean().getConnectionReservation().reserve(1).addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    Object futureResponse = request.sendTCP(future.getChannelCreator());
                    Utils.addReleaseListener(futureResponse, PingBuilder.this.peer.getConnectionBean().getConnectionReservation(), future.getChannelCreator(), 1);
                } else {
                    ((BaseFutureImpl)request.getFutureResponse()).setFailed(future);
                }
            }
        });
        return request.getFutureResponse();
    }
}

