/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.io.IOException;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.utils.Utils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class SendDirectBuilder {
    private static final FutureResponse FUTURE_REQUEST_SHUTDOWN = new FutureResponse(null).setFailed("Peer is shutting down");
    private final Peer peer;
    private PeerAddress peerAddress;
    private ChannelBuffer buffer;
    private PeerConnection connection;
    private Object object;
    private FutureChannelCreator futureChannelCreator;

    public SendDirectBuilder(Peer peer) {
        this.peer = peer;
    }

    public PeerAddress getPeerAddress() {
        return this.peerAddress;
    }

    public SendDirectBuilder setPeerAddress(PeerAddress peerAddress) {
        this.peerAddress = peerAddress;
        return this;
    }

    public ChannelBuffer getBuffer() {
        return this.buffer;
    }

    public SendDirectBuilder setBuffer(ChannelBuffer buffer) {
        this.buffer = buffer;
        return this;
    }

    public PeerConnection getConnection() {
        return this.connection;
    }

    public SendDirectBuilder setConnection(PeerConnection connection) {
        this.connection = connection;
        return this;
    }

    public Object getObject() {
        return this.object;
    }

    public SendDirectBuilder setObject(Object object) {
        this.object = object;
        return this;
    }

    public FutureChannelCreator getFutureChannelCreator() {
        return this.futureChannelCreator;
    }

    public SendDirectBuilder setFutureChannelCreator(FutureChannelCreator futureChannelCreator) {
        this.futureChannelCreator = futureChannelCreator;
        return this;
    }

    public FutureResponse start() {
        boolean raw;
        boolean keepAlive;
        if (this.peer.isShutdown()) {
            return FUTURE_REQUEST_SHUTDOWN;
        }
        if (this.peerAddress != null && this.connection == null) {
            keepAlive = false;
        } else if (this.peerAddress == null && this.connection != null) {
            keepAlive = true;
        } else {
            throw new IllegalArgumentException("either remotePeer or connection has to be set");
        }
        if (this.object != null && this.buffer == null) {
            byte[] me;
            try {
                me = Utils.encodeJavaObject(this.object);
            }
            catch (IOException e) {
                FutureResponse futureResponse = new FutureResponse(null);
                return futureResponse.setFailed("cannot serialize object: " + e);
            }
            this.buffer = ChannelBuffers.wrappedBuffer((byte[])me);
            raw = false;
        } else {
            raw = true;
        }
        if (this.buffer != null) {
            if (keepAlive) {
                return this.sendDirectAlive(raw);
            }
            if (this.futureChannelCreator == null) {
                this.futureChannelCreator = this.peer.getConnectionBean().getConnectionReservation().reserve(1, "send-direct-builder");
            }
            return this.sendDirectClose(raw);
        }
        throw new IllegalArgumentException("either object or requestBuffer has to be set");
    }

    private FutureResponse sendDirectAlive(boolean raw) {
        RequestHandlerTCP<FutureResponse> request = this.peer.getDirectDataRPC().prepareSend(this.connection.getDestination(), this.buffer.slice(), raw);
        request.setKeepAlive(true);
        try {
            this.connection.aquireSingleConnection();
        }
        catch (InterruptedException e) {
            request.getFutureResponse().setFailed("Interupted " + e);
        }
        request.sendTCP(this.connection.getChannelCreator(), this.connection.getIdleTCPMillis());
        request.getFutureResponse().addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                SendDirectBuilder.this.connection.releaseSingleConnection();
            }
        });
        return request.getFutureResponse();
    }

    private FutureResponse sendDirectClose(boolean raw) {
        final RequestHandlerTCP<FutureResponse> request = this.peer.getDirectDataRPC().prepareSend(this.peerAddress, this.buffer.slice(), raw);
        this.futureChannelCreator.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    Object futureResponse = request.sendTCP(future.getChannelCreator());
                    Utils.addReleaseListenerAll(futureResponse, SendDirectBuilder.this.peer.getConnectionBean().getConnectionReservation(), future.getChannelCreator());
                } else {
                    ((BaseFutureImpl)request.getFutureResponse()).setFailed(future);
                }
            }
        });
        return request.getFutureResponse();
    }
}

