/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.util.HashMap;
import java.util.Map;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureTask;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.RequestP2PConfiguration;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.Data;
import net.tomp2p.task.Worker;

public class SubmitBuilder {
    private static final FutureTask FUTURE_TASK_SHUTDOWN = (FutureTask)new FutureTask().setFailed("Peer is shutting down");
    private static final Map<Number160, Data> EMPTY_MAP = new HashMap<Number160, Data>();
    private final Number160 locationKey;
    private final Worker worker;
    private final Peer peer;
    private Map<Number160, Data> dataMap;
    private RoutingConfiguration routingConfiguration;
    private RequestP2PConfiguration requestP2PConfiguration;
    private FutureChannelCreator futureChannelCreator;
    private boolean signMessage = false;
    private boolean isManualCleanup = false;

    public SubmitBuilder(Peer peer, Number160 locationKey, Worker worker) {
        this.peer = peer;
        this.locationKey = locationKey;
        this.worker = worker;
    }

    public Map<Number160, Data> getDataMap() {
        return this.dataMap;
    }

    public SubmitBuilder setDataMap(Map<Number160, Data> dataMap) {
        this.dataMap = dataMap;
        return this;
    }

    public RoutingConfiguration getRoutingConfiguration() {
        return this.routingConfiguration;
    }

    public SubmitBuilder setRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this;
    }

    public RequestP2PConfiguration getRequestP2PConfiguration() {
        return this.requestP2PConfiguration;
    }

    public SubmitBuilder setRequestP2PConfiguration(RequestP2PConfiguration requestP2PConfiguration) {
        this.requestP2PConfiguration = requestP2PConfiguration;
        return this;
    }

    public FutureChannelCreator getFutureChannelCreator() {
        return this.futureChannelCreator;
    }

    public SubmitBuilder setFutureChannelCreator(FutureChannelCreator futureChannelCreator) {
        this.futureChannelCreator = futureChannelCreator;
        return this;
    }

    public boolean isSignMessage() {
        return this.signMessage;
    }

    public SubmitBuilder setSignMessage(boolean signMessage) {
        this.signMessage = signMessage;
        return this;
    }

    public SubmitBuilder signMessage() {
        this.signMessage = true;
        return this;
    }

    public boolean isManualCleanup() {
        return this.isManualCleanup;
    }

    public SubmitBuilder setManualCleanup(boolean isManualCleanup) {
        this.isManualCleanup = isManualCleanup;
        return this;
    }

    public SubmitBuilder manualCleanup() {
        this.isManualCleanup = true;
        return this;
    }

    public FutureTask start() {
        if (this.peer.isShutdown()) {
            return FUTURE_TASK_SHUTDOWN;
        }
        if (this.dataMap == null) {
            this.dataMap = EMPTY_MAP;
        }
        if (this.routingConfiguration == null) {
            this.routingConfiguration = new RoutingConfiguration(3, 5, 10, 2);
        }
        if (this.requestP2PConfiguration == null) {
            this.requestP2PConfiguration = new RequestP2PConfiguration(1, 0, 1);
        }
        if (this.futureChannelCreator == null) {
            this.futureChannelCreator = this.peer.reserve(this.routingConfiguration, this.requestP2PConfiguration, "submit-builder");
        }
        return this.peer.getDistributedTask().submit(this.locationKey, this.dataMap, this.worker, this.routingConfiguration, this.requestP2PConfiguration, this.futureChannelCreator, this.signMessage, this.isManualCleanup, this.peer.getConnectionBean().getConnectionReservation());
    }
}

