/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureTracker;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.p2p.TrackerConfiguration;
import net.tomp2p.peers.Number160;

public abstract class TrackerBuilder<K extends TrackerBuilder<K>> {
    public static final Number160 DEFAULT_DOMAIN = Number160.createHash("default-tracker");
    protected static final FutureTracker FUTURE_TRACKER_SHUTDOWN = (FutureTracker)new FutureTracker().setFailed("Peer is shutting down");
    protected final Peer peer;
    protected final Number160 locationKey;
    protected Number160 domainKey;
    protected RoutingConfiguration routingConfiguration;
    protected TrackerConfiguration trackerConfiguration;
    protected FutureChannelCreator futureChannelCreator;
    private K self;

    public TrackerBuilder(Peer peer, Number160 locationKey) {
        this.peer = peer;
        this.locationKey = locationKey;
    }

    public void self(K self) {
        this.self = self;
    }

    public Number160 getDomainKey() {
        return this.domainKey;
    }

    public K setDomainKey(Number160 domainKey) {
        this.domainKey = domainKey;
        return this.self;
    }

    public RoutingConfiguration getRoutingConfiguration() {
        return this.routingConfiguration;
    }

    public K setRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this.self;
    }

    public TrackerConfiguration getTrackerConfiguration() {
        return this.trackerConfiguration;
    }

    public K setTrackerConfiguration(TrackerConfiguration trackerConfiguration) {
        this.trackerConfiguration = trackerConfiguration;
        return this.self;
    }

    public FutureChannelCreator getFutureChannelCreator() {
        return this.futureChannelCreator;
    }

    public K setFutureChannelCreator(FutureChannelCreator futureChannelCreator) {
        this.futureChannelCreator = futureChannelCreator;
        return this.self;
    }

    public void preBuild(String name) {
        if (this.domainKey == null) {
            this.domainKey = DEFAULT_DOMAIN;
        }
        if (this.routingConfiguration == null) {
            this.routingConfiguration = new RoutingConfiguration(5, 10, 2);
        }
        if (this.trackerConfiguration == null) {
            int size = this.peer.getPeerBean().getPeerMap().size() + 1;
            this.trackerConfiguration = new TrackerConfiguration(Math.min(size, 3), 5, 3, 30);
        }
        if (this.futureChannelCreator == null) {
            int conn = Math.max(this.routingConfiguration.getParallel(), this.trackerConfiguration.getParallel());
            this.futureChannelCreator = this.peer.getConnectionBean().getConnectionReservation().reserve(conn);
        }
    }

    public abstract FutureTracker start();
}

