/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ObjectDataReply;
import net.tomp2p.rpc.RawDataReply;
import net.tomp2p.rpc.ReplyHandler;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import net.tomp2p.utils.Utils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class DirectDataRPC
extends ReplyHandler {
    private volatile RawDataReply rawDataReply;
    private volatile ObjectDataReply objectDataReply;

    public DirectDataRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.registerIoHandler(Message.Command.DIRECT_DATA);
    }

    public FutureResponse send(PeerAddress remotePeer, ChannelBuffer buffer, boolean raw, ChannelCreator channelCreator, boolean forceUDP) {
        return this.send(remotePeer, buffer, raw, channelCreator, this.getConnectionBean().getConfiguration().getIdleTCPMillis(), forceUDP);
    }

    public FutureResponse send(PeerAddress remotePeer, ChannelBuffer buffer, boolean raw, ChannelCreator channelCreator, int idleTCPMillis, boolean forceUDP) {
        Message message = this.createMessage(remotePeer, Message.Command.DIRECT_DATA, raw ? Message.Type.REQUEST_1 : Message.Type.REQUEST_2);
        message.setPayload(buffer);
        FutureResponse futureResponse = new FutureResponse(message, raw);
        if (!forceUDP) {
            RequestHandlerTCP<FutureResponse> requestHandler = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
            return requestHandler.sendTCP(channelCreator, idleTCPMillis);
        }
        RequestHandlerUDP<FutureResponse> requestHandler = new RequestHandlerUDP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
        return requestHandler.sendUDP(channelCreator);
    }

    public RequestHandlerTCP<FutureResponse> prepareSend(PeerAddress remotePeer, ChannelBuffer buffer, boolean raw) {
        Message message = this.createMessage(remotePeer, Message.Command.DIRECT_DATA, raw ? Message.Type.REQUEST_1 : Message.Type.REQUEST_2);
        message.setPayload(buffer);
        FutureResponse futureResponse = new FutureResponse(message, raw);
        RequestHandlerTCP<FutureResponse> requestHandler = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
        return requestHandler;
    }

    public void setReply(RawDataReply rawDataReply) {
        this.rawDataReply = rawDataReply;
    }

    public void setReply(ObjectDataReply objectDataReply) {
        this.objectDataReply = objectDataReply;
    }

    public boolean hasRawDataReply() {
        return this.rawDataReply != null;
    }

    public boolean hasObjectDataReply() {
        return this.objectDataReply != null;
    }

    @Override
    public Message handleResponse(Message message, boolean sign) throws Exception {
        if (message.getType() != Message.Type.REQUEST_1 && message.getType() != Message.Type.REQUEST_2 || message.getCommand() != Message.Command.DIRECT_DATA) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        Message responseMessage = this.createResponseMessage(message, Message.Type.OK);
        if (sign) {
            responseMessage.setPublicKeyAndSign(this.getPeerBean().getKeyPair());
        }
        RawDataReply rawDataReply2 = this.rawDataReply;
        ObjectDataReply objectDataReply2 = this.objectDataReply;
        if (message.getType() == Message.Type.REQUEST_1 && rawDataReply2 == null) {
            responseMessage.setType(Message.Type.NOT_FOUND);
        } else if (message.getType() == Message.Type.REQUEST_2 && objectDataReply2 == null) {
            responseMessage.setType(Message.Type.NOT_FOUND);
        } else {
            ChannelBuffer requestBuffer = message.getPayload1();
            if (message.getType() == Message.Type.REQUEST_1) {
                ChannelBuffer replyBuffer = rawDataReply2.reply(message.getSender(), requestBuffer);
                if (replyBuffer == null) {
                    responseMessage.setType(Message.Type.NOT_FOUND);
                } else if (replyBuffer == requestBuffer) {
                    responseMessage.setType(Message.Type.OK);
                } else {
                    responseMessage.setPayload(replyBuffer);
                }
            } else {
                Object obj = Utils.decodeJavaObject(requestBuffer);
                Object reply = objectDataReply2.reply(message.getSender(), obj);
                if (reply == null) {
                    responseMessage.setType(Message.Type.NOT_FOUND);
                } else if (reply == obj) {
                    responseMessage.setType(Message.Type.OK);
                } else {
                    byte[] me = Utils.encodeJavaObject(reply);
                    responseMessage.setPayload(ChannelBuffers.wrappedBuffer((byte[])me));
                }
            }
        }
        return responseMessage;
    }
}

