/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ReplyHandler;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import net.tomp2p.storage.TrackerData;
import net.tomp2p.storage.TrackerStorage;
import net.tomp2p.utils.CacheMap;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerExchangeRPC
extends ReplyHandler {
    private static final Logger logger = LoggerFactory.getLogger(PeerExchangeRPC.class);
    public static final int SENT_PEERS_CACHE_SIZE = 1000;
    private final Map<Number160, Set<Number160>> sentPeers;

    public PeerExchangeRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.registerIoHandler(Message.Command.PEX);
        this.sentPeers = new CacheMap<Number160, Set<Number160>>(1000, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse peerExchange(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, boolean isReplication, ChannelCreator channelCreator, boolean forceTCP) {
        FutureResponse futureResponse;
        Map<Number160, TrackerData> peers;
        Set<Number160> tmp1;
        Message message = this.createMessage(remotePeer, Message.Command.PEX, isReplication ? Message.Type.REQUEST_FF_2 : Message.Type.REQUEST_FF_1);
        Map<Number160, Set<Number160>> map = this.sentPeers;
        synchronized (map) {
            tmp1 = this.sentPeers.get(remotePeer.getID());
            if (tmp1 == null) {
                tmp1 = new HashSet<Number160>();
                this.sentPeers.put(remotePeer.getID(), tmp1);
            }
        }
        if (isReplication) {
            peers = this.getPeerBean().getTrackerStorage().meshPeers(locationKey, domainKey);
            if (logger.isDebugEnabled()) {
                logger.debug("we got stored meshPeers size:" + peers.size());
            }
        } else {
            peers = this.getPeerBean().getTrackerStorage().activePeers(locationKey, domainKey);
            if (logger.isDebugEnabled()) {
                logger.debug("we got stored activePeers size:" + peers.size());
            }
        }
        Set<Number160> set = tmp1;
        synchronized (set) {
            peers = Utils.subtract(peers, tmp1);
            peers = Utils.limit(peers, 35);
            tmp1.addAll(peers.keySet());
        }
        message.setKeyKey(locationKey, domainKey);
        if (peers.size() > 0) {
            message.setTrackerData(peers.values());
        }
        if (peers.size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("sent (" + message.getSender().getID() + ") to " + remotePeer.getID() + " / " + peers.size());
            }
            futureResponse = new FutureResponse(message);
            if (!forceTCP) {
                RequestHandlerUDP<FutureResponse> requestHandler = new RequestHandlerUDP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
                return requestHandler.fireAndForgetUDP(channelCreator);
            }
            RequestHandlerTCP<FutureResponse> requestHandler = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
            return requestHandler.fireAndForgetTCP(channelCreator);
        }
        futureResponse = new FutureResponse(message);
        futureResponse.setResponse();
        return futureResponse;
    }

    @Override
    public Message handleResponse(Message message, boolean sign) throws Exception {
        if (message.getType() != Message.Type.REQUEST_FF_1 && message.getType() != Message.Type.REQUEST_FF_2 || message.getCommand() != Message.Command.PEX) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        Collection<TrackerData> tmp = message.getTrackerData();
        Number160 locationKey = message.getKeyKey1();
        Number160 domainKey = message.getKeyKey2();
        Collection<Number160> removedKeys = message.getKeys();
        if (tmp != null && tmp.size() > 0 && locationKey != null && domainKey != null) {
            PeerAddress referrer = message.getSender();
            for (TrackerData data : tmp) {
                PeerAddress trackerEntry = data.getPeerAddress();
                this.getPeerBean().getTrackerStorage().putReferred(locationKey, domainKey, trackerEntry, referrer, data.getAttachement(), data.getOffset(), data.getLength(), message.getType() == Message.Type.REQUEST_FF_1 ? TrackerStorage.ReferrerType.ACTIVE : TrackerStorage.ReferrerType.MESH);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Adding " + data.getPeerAddress() + " to the map. I'm " + message.getRecipient());
            }
            if (removedKeys != null) {
                for (Number160 key : removedKeys) {
                    this.getPeerBean().getTrackerStorage().removeReferred(locationKey, domainKey, key, referrer);
                }
            }
        }
        return message;
    }
}

