/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.io.IOException;
import java.security.KeyPair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ReplyHandler;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import net.tomp2p.storage.Data;
import net.tomp2p.task.TaskManager;
import net.tomp2p.task.TaskStatus;
import net.tomp2p.task.Worker;
import net.tomp2p.utils.Utils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRPC
extends ReplyHandler {
    private static final Logger logger = LoggerFactory.getLogger(TaskRPC.class);
    private final TaskManager taskManager;

    public TaskRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.taskManager = peerBean.getTaskManager();
        this.registerIoHandler(Message.Command.TASK);
    }

    public FutureResponse sendTask(PeerAddress remotePeer, ChannelCreator channelCreator, Number160 taskID, Map<Number160, Data> dataMap, Worker mapper, KeyPair keyPair, boolean forceUDP, boolean sign) {
        Message message = this.createMessage(remotePeer, Message.Command.TASK, Message.Type.REQUEST_1);
        FutureResponse futureResponse = new FutureResponse(message);
        try {
            byte[] me = Utils.encodeJavaObject(mapper);
            ChannelBuffer payload = ChannelBuffers.wrappedBuffer((byte[])me);
            message.setPayload(payload);
            message.setDataMap(dataMap);
            message.setKey(taskID);
            if (sign) {
                message.setPublicKeyAndSign(keyPair);
            }
            if (forceUDP) {
                RequestHandlerUDP<FutureResponse> requestHandler = new RequestHandlerUDP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
                if (logger.isDebugEnabled()) {
                    logger.debug("send Task " + message);
                }
                return requestHandler.sendUDP(channelCreator);
            }
            RequestHandlerTCP<FutureResponse> requestHandler = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
            if (logger.isDebugEnabled()) {
                logger.debug("send Task " + message);
            }
            return requestHandler.sendTCP(channelCreator);
        }
        catch (IOException ioe) {
            futureResponse.setFailed(ioe.toString());
            if (logger.isErrorEnabled()) {
                ioe.printStackTrace();
            }
            return futureResponse;
        }
    }

    public FutureResponse sendResult(PeerAddress remotePeer, ChannelCreator channelCreator, Number160 taskID, Map<Number160, Data> dataMap, KeyPair keyPair, boolean forceUDP, boolean sign) {
        Message message = this.createMessage(remotePeer, Message.Command.TASK, Message.Type.REQUEST_3);
        FutureResponse futureResponse = new FutureResponse(message);
        if (dataMap != null) {
            message.setDataMap(dataMap);
        }
        message.setKey(taskID);
        if (sign) {
            message.setPublicKeyAndSign(keyPair);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("send Result " + message);
        }
        if (forceUDP) {
            RequestHandlerUDP<FutureResponse> requestHandler = new RequestHandlerUDP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
            return requestHandler.sendUDP(channelCreator);
        }
        RequestHandlerTCP<FutureResponse> requestHandler = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
        return requestHandler.sendTCP(channelCreator);
    }

    public FutureResponse taskStatus(PeerAddress remotePeer, ChannelCreator channelCreator, Collection<Number160> taskIDs, boolean forceTCP) {
        Message message = this.createMessage(remotePeer, Message.Command.TASK, Message.Type.REQUEST_2);
        message.setKeys(taskIDs);
        FutureResponse futureResponse = new FutureResponse(message);
        if (!forceTCP) {
            RequestHandlerUDP<FutureResponse> requestHandler = new RequestHandlerUDP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
            return requestHandler.sendUDP(channelCreator);
        }
        RequestHandlerTCP<FutureResponse> requestHandler = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
        return requestHandler.sendTCP(channelCreator);
    }

    @Override
    public Message handleResponse(Message message, boolean sign) throws Exception {
        if (message.getType() != Message.Type.REQUEST_1 && message.getType() != Message.Type.REQUEST_2 && message.getType() != Message.Type.REQUEST_3 || message.getCommand() != Message.Command.TASK) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("send Task - received " + message);
        }
        Message responseMessage = this.createResponseMessage(message, Message.Type.OK);
        if (sign) {
            responseMessage.setPublicKeyAndSign(this.getPeerBean().getKeyPair());
        }
        if (message.getType() == Message.Type.REQUEST_1) {
            Number160 taskId = message.getKey();
            Map<Number160, Data> dataMap = message.getDataMap();
            ChannelBuffer channelBuffer = message.getPayload1();
            Object obj = Utils.decodeJavaObject(channelBuffer);
            Worker mapper = (Worker)obj;
            int queuePosition = this.taskManager.submitTask(this.getPeerBean().getPeer(), taskId, mapper, dataMap, message.getSender(), sign);
            responseMessage.setInteger(queuePosition);
        } else if (message.getType() == Message.Type.REQUEST_2) {
            Collection<Number160> taskIDs = message.getKeys();
            HashMap<Number160, Data> dataMap = new HashMap<Number160, Data>();
            for (Number160 taskId : taskIDs) {
                Number320 taskKey = new Number320(taskId, message.getSender().getID());
                TaskStatus taskStatus = this.taskManager.taskStatus(taskKey);
                Data data = new Data(taskStatus);
                dataMap.put(taskId, data);
            }
            responseMessage.setDataMap(dataMap);
            if (logger.isDebugEnabled()) {
                logger.debug("finished task status for tasks " + taskIDs);
            }
        } else if (message.getType() == Message.Type.REQUEST_3) {
            Number160 taskId = message.getKey();
            Map<Number160, Data> dataMap = message.getDataMap();
            Number320 taskKey = new Number320(taskId, message.getSender().getID());
            this.taskManager.notifyListeners(taskKey, dataMap);
        } else {
            responseMessage.setType(Message.Type.NOT_FOUND);
        }
        return responseMessage;
    }
}

