/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.PublicKey;
import net.tomp2p.peers.Number160;
import net.tomp2p.utils.Timings;
import net.tomp2p.utils.Utils;

public class Data
implements Serializable {
    private static final long serialVersionUID = -5023493840082652284L;
    private final byte[] data;
    private final int offset;
    private final int length;
    private final long validFromMillis;
    private final Number160 peerId;
    private int ttlSeconds;
    private Number160 hash;
    private boolean protectedEntry;
    private boolean directReplication;
    private boolean fileReference;
    private PublicKey publicKey;

    public Data(Object object) throws IOException {
        this(object, null);
    }

    public Data(Object object, Number160 peerId) throws IOException {
        this(Utils.encodeJavaObject(object), peerId);
    }

    public Data(byte[] data) {
        this(data, (Number160)null);
    }

    public Data(byte[] data, Number160 peerId) {
        this(data, 0, data.length, peerId);
    }

    public Data(ByteBuffer[] buffer, int length, Number160 peerId) {
        this.data = new byte[length];
        int offset = 0;
        for (int i = 0; i < buffer.length; ++i) {
            int rem = buffer[i].remaining();
            buffer[i].get(this.data, offset, rem);
            offset += rem;
        }
        this.offset = 0;
        this.length = length;
        this.validFromMillis = Timings.currentTimeMillis();
        this.peerId = peerId;
    }

    public Data(byte[] data, int offset, int length, Number160 peerId) {
        this.data = data;
        this.offset = offset;
        this.length = length;
        this.validFromMillis = Timings.currentTimeMillis();
        this.peerId = peerId;
    }

    public byte[] getData() {
        return this.data;
    }

    public Object getObject() throws ClassNotFoundException, IOException {
        return Utils.decodeJavaObject(this.data, this.offset, this.length);
    }

    public long getCreated() {
        return this.validFromMillis;
    }

    public Number160 getHash() {
        if (this.hash == null) {
            this.hash = Utils.makeSHAHash(this.data, this.offset, this.length);
        }
        return this.hash;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public long getExpirationMillis() {
        return this.ttlSeconds <= 0 ? Long.MAX_VALUE : this.validFromMillis + (long)this.ttlSeconds * 1000L;
    }

    public Number160 getPeerId() {
        return this.peerId;
    }

    public int getTTLSeconds() {
        return this.ttlSeconds;
    }

    public Data setTTLSeconds(int ttlSeconds) {
        this.ttlSeconds = ttlSeconds;
        return this;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public Data setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public boolean isFileReference() {
        return this.fileReference;
    }

    public Data setFileReference() {
        this.fileReference = true;
        return this;
    }

    public Data setFileReference(boolean fileReference) {
        this.fileReference = fileReference;
        return this;
    }

    public boolean isProtectedEntry() {
        return this.protectedEntry;
    }

    public Data setProtectedEntry() {
        this.protectedEntry = true;
        return this;
    }

    public Data setProtectedEntry(boolean protectedEntry) {
        this.protectedEntry = protectedEntry;
        return this;
    }

    public boolean isDirectReplication() {
        return this.directReplication;
    }

    public Data setDirectReplication() {
        this.directReplication = true;
        return this;
    }

    public Data setDirectReplication(boolean directReplication) {
        this.directReplication = directReplication;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Data[l:");
        sb.append(this.length);
        sb.append(",t:");
        sb.append(this.getTTLSeconds());
        sb.append(",hasPK:");
        sb.append(this.publicKey != null);
        sb.append(",h:");
        sb.append(this.getHash());
        sb.append("]");
        return sb.toString();
    }
}

