/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.KeyLock;
import net.tomp2p.storage.ReplicationStorage;

public class StorageMemoryReplication
implements ReplicationStorage {
    private final Map<Number160, Number160> responsibilityMap = new ConcurrentHashMap<Number160, Number160>();
    private final Map<Number160, Set<Number160>> responsibilityMapRev = new ConcurrentHashMap<Number160, Set<Number160>>();
    private final KeyLock<Number160> responsibilityLock = new KeyLock();

    @Override
    public Number160 findPeerIDForResponsibleContent(Number160 locationKey) {
        return this.responsibilityMap.get(locationKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Number160> findContentForResponsiblePeerID(Number160 peerID) {
        Collection contentIDs = this.responsibilityMapRev.get(peerID);
        if (contentIDs == null) {
            return Collections.emptyList();
        }
        Lock lock = this.responsibilityLock.lock(peerID);
        try {
            ArrayList<Number160> arrayList = new ArrayList<Number160>(contentIDs);
            return arrayList;
        }
        finally {
            this.responsibilityLock.unlock(peerID, lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateResponsibilities(Number160 locationKey, Number160 peerId) {
        boolean isNew = true;
        Number160 oldPeerId = this.responsibilityMap.put(locationKey, peerId);
        Lock lock1 = this.responsibilityLock.lock(peerId);
        try {
            Set<Number160> contentIDs = this.putIfAbsent1(peerId, new HashSet<Number160>());
            contentIDs.add(locationKey);
        }
        finally {
            this.responsibilityLock.unlock(peerId, lock1);
        }
        if (oldPeerId != null) {
            boolean bl = isNew = !oldPeerId.equals(peerId);
            if (isNew) {
                Lock lock2 = this.responsibilityLock.lock(oldPeerId);
                try {
                    this.removeRevResponsibility(oldPeerId, locationKey);
                }
                finally {
                    this.responsibilityLock.unlock(oldPeerId, lock2);
                }
            }
        }
        return isNew;
    }

    private Set<Number160> putIfAbsent1(Number160 peerId, Set<Number160> hashSet) {
        Set<Number160> contentIDs = ((ConcurrentMap)this.responsibilityMapRev).putIfAbsent(peerId, hashSet);
        return contentIDs == null ? hashSet : contentIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResponsibility(Number160 locationKey) {
        Number160 peerId = this.responsibilityMap.remove(locationKey);
        if (peerId == null) {
            return;
        }
        Lock lock = this.responsibilityLock.lock(peerId);
        try {
            this.removeRevResponsibility(peerId, locationKey);
        }
        finally {
            this.responsibilityLock.unlock(peerId, lock);
        }
    }

    private void removeRevResponsibility(Number160 peerId, Number160 locationKey) {
        if (peerId == null || locationKey == null) {
            throw new IllegalArgumentException("both keys must not be null");
        }
        Set<Number160> contentIDs = this.responsibilityMapRev.get(peerId);
        if (contentIDs != null) {
            contentIDs.remove(locationKey);
            if (contentIDs.isEmpty()) {
                this.responsibilityMapRev.remove(peerId);
            }
        }
    }
}

