/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.task;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.Scheduler;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.Cancellable;
import net.tomp2p.futures.FutureAsyncTask;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.TaskRPC;
import net.tomp2p.storage.Data;
import net.tomp2p.task.TaskResultListener;
import net.tomp2p.task.Worker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTask
implements TaskResultListener {
    private static final Logger logger = LoggerFactory.getLogger(AsyncTask.class);
    private final TaskRPC taskRPC;
    private final Scheduler scheduler;
    private final PeerBean peerBean;
    private final Map<Number320, FutureAsyncTask> tasks = new ConcurrentHashMap<Number320, FutureAsyncTask>();

    public AsyncTask(TaskRPC taskRPC, Scheduler scheduler, PeerBean peerBean) {
        this.taskRPC = taskRPC;
        this.scheduler = scheduler;
        this.peerBean = peerBean;
    }

    public FutureAsyncTask submit(final PeerAddress remotePeer, ChannelCreator channelCreator, final Number160 taskId, Map<Number160, Data> dataMap, Worker mapper, boolean forceUDP, boolean sign) {
        final Number320 taskKey = new Number320(taskId, remotePeer.getID());
        final FutureAsyncTask futureAsyncTask = new FutureAsyncTask(remotePeer);
        futureAsyncTask.addCancellation(new Cancellable(){

            @Override
            public void cancel() {
                AsyncTask.this.taskFailed(taskKey);
            }
        });
        this.tasks.put(taskKey, futureAsyncTask);
        FutureResponse futureResponse = this.taskRPC.sendTask(remotePeer, channelCreator, taskId, dataMap, mapper, this.peerBean.getKeyPair(), forceUDP, sign);
        futureResponse.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                if (future.isSuccess()) {
                    AsyncTask.this.scheduler.keepTrack(remotePeer, taskId, AsyncTask.this);
                } else {
                    futureAsyncTask.setFailed(future);
                }
            }
        });
        return futureAsyncTask;
    }

    @Override
    public void taskReceived(Number320 taskKey, Map<Number160, Data> dataMap) {
        if (logger.isDebugEnabled()) {
            logger.debug("Task received " + taskKey);
        }
        this.scheduler.stopKeepTrack(taskKey);
        FutureAsyncTask futureAsyncTask = this.tasks.remove(taskKey);
        if (futureAsyncTask == null) {
            logger.error("Task that was completed was not in the tracking list: " + taskKey);
            return;
        }
        futureAsyncTask.setDataMap(dataMap);
    }

    @Override
    public void taskFailed(Number320 taskKey) {
        FutureAsyncTask futureAsyncTask;
        if (logger.isDebugEnabled()) {
            logger.debug("Task failed " + taskKey);
        }
        if ((futureAsyncTask = this.tasks.remove(taskKey)) == null) {
            return;
        }
        futureAsyncTask.setFailed("polling faild, maybe peer died");
    }
}

