/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.utils;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder(String.format("%3$s:[%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS:%1$tL] %2$s: %4$s\n", record.getMillis(), record.getSourceClassName(), record.getLevel(), record.getMessage()));
        if (record.getThrown() != null) {
            sb.append((CharSequence)this.printThrown(record.getThrown())).append("\n");
        }
        return sb.toString();
    }

    private StringBuilder printThrown(Throwable thrown) {
        StringBuilder sb = new StringBuilder(thrown.getClass().getName());
        sb.append(" - ").append(thrown.getMessage());
        sb.append("\n");
        for (StackTraceElement trace : thrown.getStackTrace()) {
            sb.append("\tat ").append(trace).append("\n");
        }
        Throwable cause = thrown.getCause();
        if (cause != null) {
            sb.append((CharSequence)this.printThrown(cause));
        }
        return sb;
    }
}

