/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.CountDownLatch;
import net.tomp2p.connection.ProgresHandler;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.FutureSuccessEvaluator;
import net.tomp2p.futures.FutureSuccessEvaluatorCommunication;
import net.tomp2p.futures.ProgressListener;
import net.tomp2p.message.Message;

public class FutureResponse
extends BaseFutureImpl<FutureResponse> {
    private final Message requestMessage;
    private final FutureSuccessEvaluator futureSuccessEvaluator;
    private Message responseMessage;
    private ProgresHandler progressHandler;
    private final ProgressListener progressListener;
    private final CountDownLatch firstProgressHandler = new CountDownLatch(1);
    private final CountDownLatch secondProgressHandler = new CountDownLatch(1);
    private boolean reponseLater = false;

    public FutureResponse(Message requestMessage) {
        this(requestMessage, new FutureSuccessEvaluatorCommunication());
    }

    public FutureResponse(Message requestMessage, FutureSuccessEvaluator futureSuccessEvaluator) {
        this(requestMessage, futureSuccessEvaluator, null);
    }

    public FutureResponse(Message requestMessage, ProgressListener progressListener) {
        this(requestMessage, new FutureSuccessEvaluatorCommunication(), progressListener);
    }

    public FutureResponse(Message requestMessage, FutureSuccessEvaluator futureSuccessEvaluator, ProgressListener progressListener) {
        this.requestMessage = requestMessage;
        this.futureSuccessEvaluator = futureSuccessEvaluator;
        this.progressListener = progressListener;
        this.self(this);
    }

    public FutureResponse emptyResponse() {
        return this.response(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse response(Message responseMessage) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.completedAndNotify()) {
                return this;
            }
            if (responseMessage != null) {
                this.responseMessage = responseMessage;
                this.type = this.futureSuccessEvaluator.evaluate(this.requestMessage, responseMessage);
                this.reason = responseMessage.type().toString();
            } else {
                this.type = BaseFuture.FutureType.OK;
                this.reason = "Nothing to deliver...";
            }
        }
        this.notifyListeners();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean responseLater(Message responseMessage) {
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                return false;
            }
            this.reponseLater = true;
            if (responseMessage != null) {
                this.responseMessage = responseMessage;
                this.type = this.futureSuccessEvaluator.evaluate(this.requestMessage, responseMessage);
                this.reason = responseMessage.type().toString();
            } else {
                this.type = BaseFuture.FutureType.OK;
                this.reason = "Nothing to deliver...";
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean failedLater(Throwable cause) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        cause.printStackTrace(printWriter);
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                return false;
            }
            this.reponseLater = true;
            this.reason = stringWriter.toString();
            this.type = BaseFuture.FutureType.FAILED;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse responseNow() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.reponseLater && !this.completed) {
                this.failed("No future set beforehand, probably an early shutdown / timeout, or use setFailedLater() or setResponseLater()");
                return this;
            }
            if (!super.completedAndNotify()) {
                return this;
            }
        }
        this.notifyListeners();
        return this;
    }

    @Override
    protected boolean completedAndNotify() {
        if (this.reponseLater) {
            return false;
        }
        return super.completedAndNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message responseMessage() {
        Object object = this.lock;
        synchronized (object) {
            return this.responseMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message request() {
        Object object = this.lock;
        synchronized (object) {
            return this.requestMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse progressHandler(ProgresHandler progressHandler) {
        Object object = this.lock;
        synchronized (object) {
            this.progressHandler = progressHandler;
        }
        this.firstProgressHandler.countDown();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse progressFirst() throws InterruptedException {
        this.firstProgressHandler.await();
        Object object = this.lock;
        synchronized (object) {
            this.progressHandler.progres();
        }
        this.secondProgressHandler.countDown();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse progress() throws InterruptedException {
        this.secondProgressHandler.await();
        Object object = this.lock;
        synchronized (object) {
            this.progressHandler.progres();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progress(Message interMediateMessage) {
        Object object = this.lock;
        synchronized (object) {
            if (this.progressListener != null) {
                this.progressListener.progress(interMediateMessage);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("future response state:");
        sb.append(",type:").append(this.type.name()).append(",msg:").append(this.requestMessage.command()).append(",reason:").append(this.reason);
        return sb.toString();
    }
}

