/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.tomp2p.message.SignatureCodec;
import net.tomp2p.peers.Number160;
import net.tomp2p.utils.Utils;

public class DSASignatureCodec
implements SignatureCodec {
    private Number160 number1;
    private Number160 number2;

    public DSASignatureCodec() {
    }

    public DSASignatureCodec(Number160 number1, Number160 number2) {
        this.number1 = number1;
        this.number2 = number2;
    }

    @Override
    public DSASignatureCodec decode(byte[] encodedData) throws IOException {
        if (encodedData[0] != 48) {
            throw new IOException("expected sequence with value 48, but got " + encodedData[0]);
        }
        byte seqLen = encodedData[1];
        if (seqLen < 0) {
            throw new IOException("cannot handle seq legth > than 127, got " + seqLen);
        }
        if (encodedData[2] != 2) {
            throw new IOException("expected sequence with value 2, but got " + encodedData[2]);
        }
        byte intLen1 = encodedData[3];
        if (intLen1 < 0) {
            throw new IOException("cannot handle int legth > than 127, got " + intLen1);
        }
        this.number1 = this.encodeNumber(encodedData, 4, intLen1);
        if (encodedData[4 + intLen1] != 2) {
            throw new IOException("expected sequence with value 2, but got " + encodedData[4 + intLen1]);
        }
        byte intLen2 = encodedData[5 + intLen1];
        if (intLen2 < 0) {
            throw new IOException("cannot handle int legth > than 127, got " + intLen2);
        }
        this.number2 = this.encodeNumber(encodedData, 6 + intLen1, intLen2);
        return this;
    }

    private Number160 encodeNumber(byte[] encodedData, int offset, int len) throws IOException {
        if (len > 20) {
            int bias = len - 20;
            for (int i = 0; i < bias; ++i) {
                if (encodedData[offset + i] == 0) continue;
                throw new IOException("we did not expect such a large number, it should be 160bit");
            }
            return new Number160(encodedData, offset + bias, 20);
        }
        return new Number160(encodedData, offset, len);
    }

    @Override
    public byte[] encode() throws IOException {
        byte[] me = new byte[46];
        me[0] = 48;
        me[1] = 44;
        me[2] = 2;
        me[3] = 20;
        this.number1.toByteArray(me, 4);
        me[24] = 2;
        me[25] = 20;
        this.number2.toByteArray(me, 26);
        return me;
    }

    @Override
    public SignatureCodec write(ByteBuf buf) {
        buf.writeBytes(this.number1.toByteArray());
        buf.writeBytes(this.number2.toByteArray());
        return this;
    }

    public Number160 number1() {
        return this.number1;
    }

    public Number160 number2() {
        return this.number2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("sig[");
        sb.append(this.number1.toString()).append('/');
        sb.append(this.number2.toString()).append(']');
        return sb.toString();
    }

    public int hashCode() {
        return this.number1.hashCode() ^ this.number2.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DSASignatureCodec)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        DSASignatureCodec s = (DSASignatureCodec)obj;
        return Utils.equals(this.number1, s.number1) && Utils.equals(this.number2, s.number2);
    }

    @Override
    public SignatureCodec read(ByteBuf buf) {
        byte[] me = new byte[20];
        buf.readBytes(me);
        this.number1 = new Number160(me);
        buf.readBytes(me);
        this.number2 = new Number160(me);
        return this;
    }

    @Override
    public int signatureSize() {
        return 40;
    }
}

