/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import net.tomp2p.message.SignatureCodec;

public class RSASignatureCodec
implements SignatureCodec {
    private byte[] encodedData;

    @Override
    public SignatureCodec decode(byte[] encodedData) throws IOException {
        if (encodedData.length != this.signatureSize()) {
            throw new IOException("RSA signature has size " + this.signatureSize() + " received: " + encodedData.length);
        }
        this.encodedData = encodedData;
        return this;
    }

    @Override
    public byte[] encode() throws IOException {
        return this.encodedData;
    }

    @Override
    public SignatureCodec write(ByteBuf buf) {
        buf.writeBytes(this.encodedData);
        return this;
    }

    @Override
    public SignatureCodec read(ByteBuf buf) {
        this.encodedData = new byte[this.signatureSize()];
        buf.readBytes(this.encodedData);
        return this;
    }

    @Override
    public int signatureSize() {
        return 128;
    }

    public int hashCode() {
        return Arrays.hashCode(this.encodedData);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RSASignatureCodec)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RSASignatureCodec s = (RSASignatureCodec)obj;
        return Arrays.equals(s.encodedData, this.encodedData);
    }
}

