/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.PeerCreator;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureLateJoin;
import net.tomp2p.futures.FuturePeerConnection;
import net.tomp2p.p2p.AutomaticFuture;
import net.tomp2p.p2p.DistributedRouting;
import net.tomp2p.p2p.Shutdown;
import net.tomp2p.p2p.builder.AnnounceBuilder;
import net.tomp2p.p2p.builder.BootstrapBuilder;
import net.tomp2p.p2p.builder.BroadcastBuilder;
import net.tomp2p.p2p.builder.DiscoverBuilder;
import net.tomp2p.p2p.builder.PingBuilder;
import net.tomp2p.p2p.builder.SendDirectBuilder;
import net.tomp2p.p2p.builder.ShutdownBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.AnnounceRPC;
import net.tomp2p.rpc.BroadcastRPC;
import net.tomp2p.rpc.DirectDataRPC;
import net.tomp2p.rpc.NeighborRPC;
import net.tomp2p.rpc.ObjectDataReply;
import net.tomp2p.rpc.PingRPC;
import net.tomp2p.rpc.QuitRPC;
import net.tomp2p.rpc.RawDataReply;

public class Peer {
    private final PeerCreator peerCreator;
    private final Number160 peerId;
    private final int p2pId;
    private DistributedRouting distributedRouting;
    private PingRPC pingRCP;
    private QuitRPC quitRPC;
    private NeighborRPC neighborRPC;
    private DirectDataRPC directDataRPC;
    private BroadcastRPC broadcastRPC;
    private AnnounceRPC announceRPC;
    private volatile boolean shutdown = false;
    private List<AutomaticFuture> automaticFutures = Collections.synchronizedList(new ArrayList(1));
    private List<Shutdown> shutdownListeners = Collections.synchronizedList(new ArrayList(5));

    Peer(int p2pID, Number160 peerId, PeerCreator peerCreator) {
        this.p2pId = p2pID;
        this.peerId = peerId;
        this.peerCreator = peerCreator;
    }

    PeerCreator peerCreator() {
        return this.peerCreator;
    }

    public PingRPC pingRPC() {
        if (this.pingRCP == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.pingRCP;
    }

    public Peer pingRPC(PingRPC pingRCP) {
        this.pingRCP = pingRCP;
        return this;
    }

    public QuitRPC quitRPC() {
        if (this.quitRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.quitRPC;
    }

    public Peer quitRPC(QuitRPC quitRPC) {
        this.quitRPC = quitRPC;
        return this;
    }

    public NeighborRPC neighborRPC() {
        if (this.neighborRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.neighborRPC;
    }

    public Peer neighborRPC(NeighborRPC neighborRPC) {
        this.neighborRPC = neighborRPC;
        return this;
    }

    public DirectDataRPC directDataRPC() {
        if (this.directDataRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.directDataRPC;
    }

    public Peer directDataRPC(DirectDataRPC directDataRPC) {
        this.directDataRPC = directDataRPC;
        return this;
    }

    public BroadcastRPC broadcastRPC() {
        if (this.broadcastRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.broadcastRPC;
    }

    public Peer broadcastRPC(BroadcastRPC broadcastRPC) {
        this.broadcastRPC = broadcastRPC;
        return this;
    }

    public AnnounceRPC announceRPC() {
        if (this.announceRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.announceRPC;
    }

    public Peer announceRPC(AnnounceRPC announceRPC) {
        this.announceRPC = announceRPC;
        return this;
    }

    public DistributedRouting distributedRouting() {
        if (this.distributedRouting == null) {
            throw new RuntimeException("Not enabled, please enable this P2P function in PeerMaker");
        }
        return this.distributedRouting;
    }

    public void distributedRouting(DistributedRouting distributedRouting) {
        this.distributedRouting = distributedRouting;
    }

    public PeerBean peerBean() {
        return this.peerCreator.peerBean();
    }

    public ConnectionBean connectionBean() {
        return this.peerCreator.connectionBean();
    }

    public Number160 peerID() {
        return this.peerId;
    }

    public int p2pId() {
        return this.p2pId;
    }

    public PeerAddress peerAddress() {
        return this.peerBean().serverPeerAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Peer notifyAutomaticFutures(BaseFuture future) {
        List<AutomaticFuture> list = this.automaticFutures;
        synchronized (list) {
            for (AutomaticFuture automaticFuture : this.automaticFutures) {
                automaticFuture.futureCreated(future);
            }
        }
        return this;
    }

    public void rawDataReply(RawDataReply rawDataReply) {
        this.directDataRPC().rawDataReply(rawDataReply);
    }

    public void objectDataReply(ObjectDataReply objectDataReply) {
        this.directDataRPC().objectDataReply(objectDataReply);
    }

    public FuturePeerConnection createPeerConnection(PeerAddress destination) {
        return this.createPeerConnection(destination, 2000);
    }

    public FuturePeerConnection createPeerConnection(final PeerAddress destination, final int heartBeatMillis) {
        final FuturePeerConnection futureDone = new FuturePeerConnection(destination);
        final FutureChannelCreator fcc = this.connectionBean().reservation().createPermanent(1);
        fcc.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    ChannelCreator cc = fcc.channelCreator();
                    PeerConnection peerConnection = new PeerConnection(destination, cc, heartBeatMillis);
                    futureDone.done(peerConnection);
                } else {
                    futureDone.failed(future);
                }
            }
        });
        return futureDone;
    }

    public SendDirectBuilder sendDirect(PeerAddress recipientAddress) {
        return new SendDirectBuilder(this, recipientAddress);
    }

    public SendDirectBuilder sendDirect(FuturePeerConnection recipientConnection) {
        return new SendDirectBuilder(this, recipientConnection);
    }

    public SendDirectBuilder sendDirect(PeerConnection peerConnection) {
        return new SendDirectBuilder(this, peerConnection);
    }

    public BootstrapBuilder bootstrap() {
        return new BootstrapBuilder(this);
    }

    public ShutdownBuilder announceShutdown() {
        return new ShutdownBuilder(this);
    }

    public PingBuilder ping() {
        return new PingBuilder(this);
    }

    public DiscoverBuilder discover() {
        return new DiscoverBuilder(this);
    }

    public BroadcastBuilder broadcast(Number160 messageKey) {
        return new BroadcastBuilder(this, messageKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseFuture shutdown() {
        if (!this.shutdown) {
            ArrayList<Shutdown> copy;
            this.shutdown = true;
            List<Shutdown> list = this.shutdownListeners;
            synchronized (list) {
                copy = new ArrayList<Shutdown>(this.shutdownListeners);
            }
            FutureLateJoin<BaseFuture> futureLateJoin = new FutureLateJoin<BaseFuture>(this.shutdownListeners.size() + 1);
            for (Shutdown shutdown : copy) {
                futureLateJoin.add(shutdown.shutdown());
                this.removeShutdownListener(shutdown);
            }
            futureLateJoin.add(this.peerCreator.shutdown());
            return futureLateJoin;
        }
        return new FutureDone().failed("already shutting / shut down");
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public Peer addShutdownListener(Shutdown shutdown) {
        this.shutdownListeners.add(shutdown);
        return this;
    }

    public Peer removeShutdownListener(Shutdown shutdown) {
        this.shutdownListeners.remove(shutdown);
        return this;
    }

    public Peer addAutomaticFuture(AutomaticFuture automaticFuture) {
        this.automaticFutures.add(automaticFuture);
        return this;
    }

    public Peer removeAutomaticFuture(AutomaticFuture automaticFuture) {
        this.automaticFutures.remove(automaticFuture);
        return this;
    }

    public AnnounceBuilder localAnnounce() {
        return new AnnounceBuilder(this);
    }
}

