/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.net.InetAddress;
import java.util.Collection;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.connection.DiscoverResults;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureAnnounce;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureLateJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.p2p.JobScheduler;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.Builder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.utils.Utils;

public class AnnounceBuilder
implements Builder {
    private final Peer peer;
    private int port = 7700;
    private JobScheduler jobScheduler = null;
    private boolean ping = false;
    private PeerAddress peerAddress = null;
    private int intervalMillis = 10000;
    private int repetitions = 5;
    private ConnectionConfiguration connectionConfiguration = null;

    public AnnounceBuilder(Peer peer) {
        this.peer = peer;
    }

    public int port() {
        return this.port;
    }

    public AnnounceBuilder port(int port) {
        this.port = port;
        return this;
    }

    public JobScheduler jobScheduler() {
        return this.jobScheduler;
    }

    public AnnounceBuilder jobScheduler(JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
        return this;
    }

    public PeerAddress peerAddress() {
        return this.peerAddress;
    }

    public AnnounceBuilder peerAddress(PeerAddress peerAddress) {
        this.peerAddress = peerAddress.changePeerId(Number160.ZERO);
        return this;
    }

    public AnnounceBuilder peerAddressOrig(PeerAddress peerAddress) {
        this.peerAddress = peerAddress;
        return this;
    }

    public AnnounceBuilder intervalMillis(int intervalMillis) {
        this.intervalMillis = intervalMillis;
        return this;
    }

    public int intervalMillis() {
        return this.intervalMillis;
    }

    public AnnounceBuilder repetitions(int repetitions) {
        this.repetitions = repetitions;
        return this;
    }

    public int repetitions() {
        return this.repetitions;
    }

    public AnnounceBuilder ping() {
        return this;
    }

    public AnnounceBuilder setPing(boolean ping) {
        this.ping = ping;
        return this;
    }

    public boolean isPing() {
        return this.ping;
    }

    @Override
    public FutureAnnounce start() {
        if (this.connectionConfiguration == null) {
            this.connectionConfiguration = new DefaultConnectionConfiguration();
        }
        FutureAnnounce futureAnnounce = new FutureAnnounce();
        FutureAnnounce futureAnnounce2 = futureAnnounce = this.ping ? this.pingAnnounce(futureAnnounce) : this.announce(futureAnnounce);
        if (this.jobScheduler != null) {
            this.jobScheduler.start(this, this.intervalMillis, this.repetitions);
        }
        return futureAnnounce;
    }

    private FutureAnnounce pingAnnounce(final FutureAnnounce futureAnnounce) {
        FutureChannelCreator fcc = this.peer.connectionBean().reservation().create(1, 0);
        Utils.addReleaseListener(fcc, (BaseFuture)futureAnnounce);
        fcc.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    FutureResponse futureResponse = AnnounceBuilder.this.peer.announceRPC().ping(AnnounceBuilder.this.peerAddress, AnnounceBuilder.this.connectionConfiguration, future.channelCreator());
                    futureResponse.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

                        @Override
                        public void operationComplete(FutureResponse future) throws Exception {
                            if (future.isSuccess()) {
                                futureAnnounce.done();
                            } else {
                                futureAnnounce.failed(future);
                            }
                        }
                    });
                } else {
                    futureAnnounce.failed(future);
                }
            }
        });
        return futureAnnounce;
    }

    private FutureAnnounce announce(final FutureAnnounce futureAnnounce) {
        DiscoverResults discoverResults = this.peer.connectionBean().channelServer().discoverNetworks().currentDiscoverResults();
        final Collection<InetAddress> broadcastAddresses = discoverResults.existingBroadcastAddresses();
        int size = broadcastAddresses.size();
        final FutureLateJoin futureLateJoin = new FutureLateJoin(size);
        if (size > 0) {
            FutureChannelCreator fcc = this.peer.connectionBean().reservation().create(size, 0);
            Utils.addReleaseListener(fcc, (BaseFuture)futureAnnounce);
            fcc.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                @Override
                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        AnnounceBuilder.this.addPingListener(futureAnnounce, futureLateJoin);
                        for (InetAddress broadcastAddress : broadcastAddresses) {
                            PeerAddress peerAddress = new PeerAddress(Number160.ZERO, broadcastAddress, AnnounceBuilder.this.port, AnnounceBuilder.this.port);
                            FutureResponse validBroadcast = AnnounceBuilder.this.peer.announceRPC().broadcast(peerAddress, AnnounceBuilder.this.connectionConfiguration, future.channelCreator());
                            futureLateJoin.add(validBroadcast);
                        }
                    } else {
                        futureAnnounce.failed(future);
                    }
                }
            });
        } else {
            futureAnnounce.failed("No broadcast address found. Cannot ping nothing");
        }
        return futureAnnounce;
    }

    private void addPingListener(final FutureAnnounce futureAnnounce, FutureLateJoin<FutureResponse> futureLateJoin) {
        futureLateJoin.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureLateJoin<FutureResponse>>(){

            @Override
            public void operationComplete(FutureLateJoin<FutureResponse> future) throws Exception {
                if (future.futuresDone().size() > 0) {
                    futureAnnounce.done();
                } else {
                    futureAnnounce.failed(future);
                }
            }
        });
    }
}

