/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import java.util.Random;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;

public final class Number480
extends Number
implements Comparable<Number480> {
    private static final long serialVersionUID = 1L;
    public static final Number480 ZERO = new Number480(Number320.ZERO, Number160.ZERO);
    private final Number160 locationKey;
    private final Number160 domainKey;
    private final Number160 contentKey;

    public Number480(Number160 locationKey, Number160 domainKey, Number160 contentKey) {
        if (locationKey == null) {
            throw new RuntimeException("locationKey cannot be null");
        }
        this.locationKey = locationKey;
        if (domainKey == null) {
            throw new RuntimeException("domainKey cannot be null");
        }
        this.domainKey = domainKey;
        if (contentKey == null) {
            throw new RuntimeException("contentKey cannot be null");
        }
        this.contentKey = contentKey;
    }

    public Number480(Number320 key, Number160 contentKey) {
        this(key.locationKey(), key.domainKey(), contentKey);
    }

    public Number480(Random rnd) {
        this(new Number160(rnd), new Number160(rnd), new Number160(rnd));
    }

    public Number160 locationKey() {
        return this.locationKey;
    }

    public Number160 domainKey() {
        return this.domainKey;
    }

    public Number160 contentKey() {
        return this.contentKey;
    }

    public int hashCode() {
        return this.locationKey.hashCode() ^ this.domainKey.hashCode() ^ this.contentKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Number480)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Number480 cmp = (Number480)obj;
        return this.locationKey.equals(cmp.locationKey) && this.domainKey.equals(cmp.domainKey) && this.contentKey.equals(cmp.contentKey);
    }

    @Override
    public int compareTo(Number480 o) {
        int diff = this.locationKey.compareTo(o.locationKey);
        if (diff != 0) {
            return diff;
        }
        diff = this.domainKey.compareTo(o.domainKey);
        if (diff != 0) {
            return diff;
        }
        return this.contentKey.compareTo(o.contentKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.locationKey.toString()).append(",");
        sb.append(this.domainKey.toString()).append(",");
        sb.append(this.contentKey.toString()).append("]");
        return sb.toString();
    }

    @Override
    public int intValue() {
        return this.contentKey.intValue();
    }

    @Override
    public long longValue() {
        return this.contentKey.longValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        return this.locationKey.doubleValue() * Math.pow(2.0, 320.0) + this.domainKey.doubleValue() * Math.pow(2.0, 160.0) + this.contentKey.doubleValue();
    }
}

