/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import java.util.Random;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;

public final class Number640
extends Number
implements Comparable<Number640> {
    private static final long serialVersionUID = 1L;
    public static final Number640 ZERO = new Number640(Number480.ZERO, Number160.ZERO);
    private final Number160 locationKey;
    private final Number160 domainKey;
    private final Number160 contentKey;
    private final Number160 versionKey;

    public Number640(Number160 locationKey, Number160 domainKey, Number160 contentKey, Number160 versionKey) {
        if (locationKey == null) {
            throw new RuntimeException("locationKey cannot be null");
        }
        this.locationKey = locationKey;
        if (domainKey == null) {
            throw new RuntimeException("domainKey cannot be null");
        }
        this.domainKey = domainKey;
        if (contentKey == null) {
            throw new RuntimeException("contentKey cannot be null");
        }
        this.contentKey = contentKey;
        if (versionKey == null) {
            throw new RuntimeException("versionKey cannot be null");
        }
        this.versionKey = versionKey;
    }

    public Number640(Number480 key, Number160 versionKey) {
        this(key.locationKey(), key.domainKey(), key.contentKey(), versionKey);
    }

    public Number640(Number320 key, Number160 contentKey, Number160 versionKey) {
        this(key.locationKey(), key.domainKey(), contentKey, versionKey);
    }

    public Number640(Random rnd) {
        this(new Number160(rnd), new Number160(rnd), new Number160(rnd), new Number160(rnd));
    }

    public Number160 locationKey() {
        return this.locationKey;
    }

    public Number160 domainKey() {
        return this.domainKey;
    }

    public Number160 contentKey() {
        return this.contentKey;
    }

    public Number160 versionKey() {
        return this.versionKey;
    }

    public int hashCode() {
        return this.locationKey.hashCode() ^ this.domainKey.hashCode() ^ this.contentKey.hashCode() ^ this.versionKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Number640)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Number640 cmp = (Number640)obj;
        boolean t1 = this.locationKey.equals(cmp.locationKey);
        boolean t2 = this.domainKey.equals(cmp.domainKey);
        boolean t3 = this.contentKey.equals(cmp.contentKey);
        boolean t4 = this.versionKey.equals(cmp.versionKey);
        return t1 && t2 && t3 && t4;
    }

    @Override
    public int compareTo(Number640 o) {
        int diff = this.locationKey.compareTo(o.locationKey);
        if (diff != 0) {
            return diff;
        }
        diff = this.domainKey.compareTo(o.domainKey);
        if (diff != 0) {
            return diff;
        }
        diff = this.contentKey.compareTo(o.contentKey);
        if (diff != 0) {
            return diff;
        }
        return this.versionKey.compareTo(o.versionKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.locationKey.toString()).append(",");
        sb.append(this.domainKey.toString()).append(",");
        sb.append(this.contentKey.toString()).append(",");
        sb.append(this.versionKey.toString()).append("]");
        return sb.toString();
    }

    @Override
    public int intValue() {
        return this.contentKey.intValue();
    }

    @Override
    public long longValue() {
        return this.contentKey.longValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        return this.locationKey.doubleValue() * Math.pow(2.0, 480.0) + this.domainKey.doubleValue() * Math.pow(2.0, 320.0) + this.contentKey.doubleValue() * Math.pow(2.0, 160.0) + this.versionKey.doubleValue();
    }

    public Number640 minVersionKey() {
        return new Number640(this.locationKey, this.domainKey, this.contentKey, Number160.ZERO);
    }

    public Number640 minContentKey() {
        return new Number640(this.locationKey, this.domainKey, Number160.ZERO, Number160.ZERO);
    }

    public Number640 maxVersionKey() {
        return new Number640(this.locationKey, this.domainKey, this.contentKey, Number160.MAX_VALUE);
    }

    public Number640 maxContentKey() {
        return new Number640(this.locationKey, this.domainKey, Number160.MAX_VALUE, Number160.MAX_VALUE);
    }

    public Number320 locationAndDomainKey() {
        return new Number320(this.locationKey, this.domainKey);
    }

    public Number480 locationAndDomainAndContentKey() {
        return new Number480(this.locationKey, this.domainKey, this.contentKey);
    }
}

