/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import net.tomp2p.utils.Utils;

public class PeerSocketAddress
implements Serializable {
    private static final long serialVersionUID = 8483270473601620720L;
    private final InetAddress inetAddress;
    private final int tcpPort;
    private final int udpPort;
    private final int offset;

    public PeerSocketAddress(InetAddress inetAddress, int tcpPort, int udpPort) {
        this(inetAddress, tcpPort, udpPort, -1);
    }

    public PeerSocketAddress(InetAddress inetAddress, int tcpPort, int udpPort, int offset) {
        this.inetAddress = inetAddress;
        this.tcpPort = tcpPort;
        this.udpPort = udpPort;
        this.offset = offset;
    }

    public static PeerSocketAddress create(byte[] me, boolean isIPv4, int offsetOriginal) {
        InetAddress address;
        int offset = offsetOriginal;
        int tcpPort = ((me[offset++] & 0xFF) << 8) + (me[offset++] & 0xFF);
        int udpPort = ((me[offset++] & 0xFF) << 8) + (me[offset++] & 0xFF);
        if (isIPv4) {
            address = Utils.inet4FromBytes(me, offset);
            offset += 4;
        } else {
            address = Utils.inet6FromBytes(me, offset);
            offset += 16;
        }
        return new PeerSocketAddress(address, tcpPort, udpPort, offset);
    }

    public static PeerSocketAddress create(ByteBuf buf, boolean isIPv4) {
        InetAddress address;
        int tcpPort = buf.readUnsignedShort();
        int udpPort = buf.readUnsignedShort();
        if (isIPv4) {
            byte[] me = new byte[4];
            buf.readBytes(me);
            address = Utils.inet4FromBytes(me, 0);
        } else {
            byte[] me = new byte[16];
            buf.readBytes(me);
            address = Utils.inet6FromBytes(me, 0);
        }
        return new PeerSocketAddress(address, tcpPort, udpPort, buf.readerIndex());
    }

    public static InetSocketAddress createSocketTCP(PeerSocketAddress peerSocketAddress) {
        return new InetSocketAddress(peerSocketAddress.inetAddress(), peerSocketAddress.tcpPort());
    }

    public static InetSocketAddress createSocketUDP(PeerSocketAddress peerSocketAddress) {
        return new InetSocketAddress(peerSocketAddress.inetAddress(), peerSocketAddress.udpPort());
    }

    public InetAddress inetAddress() {
        return this.inetAddress;
    }

    public int tcpPort() {
        return this.tcpPort;
    }

    public int udpPort() {
        return this.udpPort;
    }

    public int offset() {
        return this.offset;
    }

    public byte[] toByteArray() {
        byte[] retVal;
        int size2;
        int size = this.size();
        if (size != (size2 = this.toByteArray(retVal = new byte[size], 0))) {
            throw new RuntimeException("Sizes do not match.");
        }
        return retVal;
    }

    public int toByteArray(byte[] me, int offset) {
        int offset2 = offset;
        me[offset2++] = (byte)(this.tcpPort >>> 8);
        me[offset2++] = (byte)this.tcpPort;
        me[offset2++] = (byte)(this.udpPort >>> 8);
        me[offset2++] = (byte)this.udpPort;
        if (this.inetAddress instanceof Inet4Address) {
            System.arraycopy(this.inetAddress.getAddress(), 0, me, offset2, 4);
            offset2 += 4;
        } else {
            System.arraycopy(this.inetAddress.getAddress(), 0, me, offset2, 16);
            offset2 += 16;
        }
        return offset2;
    }

    public int size() {
        return PeerSocketAddress.size(this.isIPv4());
    }

    public static int size(boolean isIPv4) {
        return 4 + (isIPv4 ? 4 : 16);
    }

    public boolean isIPv4() {
        return this.inetAddress instanceof Inet4Address;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.inetAddress);
        if (this.tcpPort == this.udpPort) {
            sb.append(",").append(this.tcpPort);
        } else {
            sb.append(",t:").append(this.tcpPort).append(",u:").append(this.udpPort);
        }
        return sb.append("]").toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PeerSocketAddress)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PeerSocketAddress psa = (PeerSocketAddress)obj;
        return psa.inetAddress.equals(this.inetAddress) && psa.tcpPort == this.tcpPort && psa.udpPort == this.udpPort;
    }

    public int hashCode() {
        return this.inetAddress.hashCode() ^ this.tcpPort ^ this.udpPort;
    }
}

