/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import net.tomp2p.peers.Number160;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBloomFilter<E>
implements Set<E>,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleBloomFilter.class);
    private static final long serialVersionUID = 3527833617516722215L;
    private static final int SIZE_HEADER_LENGTH = 2;
    private static final int SIZE_HEADER_ELEMENTS = 4;
    public static final int SIZE_HEADER = 6;
    private final int k;
    private final BitSet bitSet;
    private final int byteArraySize;
    private final int bitArraySize;
    private final int expectedElements;

    public SimpleBloomFilter(int byteArraySize, int expectedElements) {
        this(byteArraySize, expectedElements, new BitSet(byteArraySize * 8));
    }

    public SimpleBloomFilter(double falsePositiveProbability, int expectedElements) {
        double c = Math.ceil(-(Math.log(falsePositiveProbability) / Math.log(2.0))) / Math.log(2.0);
        this.expectedElements = expectedElements;
        int tmpBitArraySize = (int)Math.ceil(c * (double)expectedElements);
        this.byteArraySize = (tmpBitArraySize + 7) / 8;
        this.bitArraySize = this.byteArraySize * 8;
        double hf = (double)this.bitArraySize / (double)expectedElements * Math.log(2.0);
        this.k = (int)Math.ceil(hf);
        this.bitSet = new BitSet(this.bitArraySize);
    }

    public SimpleBloomFilter(ByteBuf channelBuffer) {
        int expectedElements;
        this.byteArraySize = channelBuffer.readUnsignedShort() - 6;
        this.bitArraySize = this.byteArraySize * 8;
        this.expectedElements = expectedElements = channelBuffer.readInt();
        double hf = (double)this.bitArraySize / (double)expectedElements * Math.log(2.0);
        this.k = (int)Math.ceil(hf);
        if (this.byteArraySize > 0) {
            byte[] me = new byte[this.byteArraySize];
            channelBuffer.readBytes(me);
            this.bitSet = BitSet.valueOf(me);
        } else {
            this.bitSet = new BitSet();
        }
    }

    public SimpleBloomFilter(int byteArraySize, int expectedElements, BitSet bitSet) {
        this.byteArraySize = byteArraySize;
        this.bitArraySize = byteArraySize * 8;
        this.expectedElements = expectedElements;
        double hf = (double)this.bitArraySize / (double)expectedElements * Math.log(2.0);
        this.k = (int)Math.ceil(hf);
        if (hf < 1.0) {
            LOG.warn("Bit size too small for storing all expected elements. For optimum result increase byteArraySize to {}", (Object)((double)expectedElements / Math.log(2.0)));
        }
        this.bitSet = bitSet;
    }

    public double expectedFalsePositiveProbability() {
        return Math.pow(1.0 - Math.exp((double)(-this.k) * (double)this.expectedElements / (double)this.bitArraySize), this.k);
    }

    public int expectedElements() {
        return this.expectedElements;
    }

    @Override
    public boolean add(E o) {
        Random r = new Random(o.hashCode());
        for (int x = 0; x < this.k; ++x) {
            this.bitSet.set(r.nextInt(this.bitArraySize), true);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E o : c) {
            this.add(o);
        }
        return false;
    }

    @Override
    public void clear() {
        for (int x = 0; x < this.bitSet.length(); ++x) {
            this.bitSet.set(x, false);
        }
    }

    @Override
    public boolean contains(Object o) {
        Random r = new Random(o.hashCode());
        for (int x = 0; x < this.k; ++x) {
            if (this.bitSet.get(r.nextInt(this.bitArraySize))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    public BitSet getBitSet() {
        return this.bitSet;
    }

    public void toByteBuf(ByteBuf buf) {
        byte[] tmp = this.bitSet.toByteArray();
        int currentByteArraySize = tmp.length;
        buf.writeShort(this.byteArraySize + 4 + 2);
        buf.writeInt(this.expectedElements);
        buf.writeBytes(this.bitSet.toByteArray());
        buf.writeZero(this.byteArraySize - currentByteArraySize);
    }

    public SimpleBloomFilter<E> merge(SimpleBloomFilter<E> toMerge) {
        if (toMerge.bitArraySize != this.bitArraySize) {
            throw new RuntimeException("this is not supposed to happen");
        }
        BitSet mergedBitSet = (BitSet)this.bitSet.clone();
        mergedBitSet.or(toMerge.bitSet);
        return new SimpleBloomFilter<E>(this.bitArraySize, this.expectedElements, mergedBitSet);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleBloomFilter)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        SimpleBloomFilter o = (SimpleBloomFilter)obj;
        return o.k == this.k && o.bitArraySize == this.bitArraySize && this.expectedElements == o.expectedElements && this.bitSet.equals(o.bitSet);
    }

    @Override
    public int hashCode() {
        int magic = 31;
        int hash = 7;
        hash = 31 * hash + this.bitSet.hashCode();
        hash = 31 * hash + this.k;
        hash = 31 * hash + this.expectedElements;
        hash = 31 * hash + this.bitArraySize;
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int length = this.bitSet.length();
        for (int i = 0; i < length; ++i) {
            sb.append(this.bitSet.get(i) ? "1" : "0");
        }
        return sb.toString();
    }

    public SimpleBloomFilter<Number160> not() {
        BitSet copy = BitSet.valueOf(this.bitSet.toByteArray());
        copy.flip(0, copy.length());
        return new SimpleBloomFilter<Number160>(this.byteArraySize, this.expectedElements, copy);
    }
}

