/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufProcessor;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.DuplicatedByteBuf;
import io.netty.buffer.SlicedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.util.CharsetUtil;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ResourceLeak;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class AlternativeCompositeByteBuf
extends ByteBuf {
    private static final ByteBufAllocator ALLOC = UnpooledByteBufAllocator.DEFAULT;
    private static final ByteBuffer FULL_BYTEBUFFER = (ByteBuffer)ByteBuffer.allocate(1).position(1);
    private final List<Component> components = new ArrayList<Component>();
    private final Component EMPTY_COMPONENT = new Component(Unpooled.EMPTY_BUFFER);
    private final ByteBufAllocator alloc;
    private final boolean direct;
    private int readerIndex;
    private int writerIndex;
    private int markedReaderIndex;
    private int markedWriterIndex;
    private volatile int refCnt = 1;
    private static final AtomicIntegerFieldUpdater<AlternativeCompositeByteBuf> refCntUpdater = AtomicIntegerFieldUpdater.newUpdater(AlternativeCompositeByteBuf.class, "refCnt");
    private boolean freed;
    private final ResourceLeak leak;
    private static final ResourceLeakDetector<ByteBuf> leakDetector = new ResourceLeakDetector(AlternativeCompositeByteBuf.class);

    public AlternativeCompositeByteBuf(ByteBufAllocator alloc, boolean direct) {
        this.alloc = alloc;
        this.direct = direct;
        this.leak = leakDetector.open((Object)this);
    }

    public AlternativeCompositeByteBuf(ByteBufAllocator alloc, boolean direct, ByteBuf ... buffers) {
        this.alloc = alloc;
        this.direct = direct;
        this.addComponent(buffers);
        this.leak = leakDetector.open((Object)this);
    }

    public int refCnt() {
        return this.refCnt;
    }

    public boolean release() {
        int refCnt;
        do {
            if ((refCnt = this.refCnt) != 0) continue;
            throw new IllegalReferenceCountException(0, -1);
        } while (!refCntUpdater.compareAndSet(this, refCnt, refCnt - 1));
        if (refCnt == 1) {
            this.deallocate();
            return true;
        }
        return false;
    }

    public boolean release(int decrement) {
        int refCnt;
        if (decrement <= 0) {
            throw new IllegalArgumentException("decrement: " + decrement + " (expected: > 0)");
        }
        do {
            if ((refCnt = this.refCnt) >= decrement) continue;
            throw new IllegalReferenceCountException(refCnt, -decrement);
        } while (!refCntUpdater.compareAndSet(this, refCnt, refCnt - decrement));
        if (refCnt == decrement) {
            this.deallocate();
            return true;
        }
        return false;
    }

    public AlternativeCompositeByteBuf retain(int increment) {
        int refCnt;
        if (increment <= 0) {
            throw new IllegalArgumentException("increment: " + increment + " (expected: > 0)");
        }
        do {
            if ((refCnt = this.refCnt) == 0) {
                throw new IllegalReferenceCountException(0, increment);
            }
            if (refCnt <= Integer.MAX_VALUE - increment) continue;
            throw new IllegalReferenceCountException(refCnt, increment);
        } while (!refCntUpdater.compareAndSet(this, refCnt, refCnt + increment));
        return this;
    }

    public AlternativeCompositeByteBuf retain() {
        int refCnt;
        do {
            if ((refCnt = this.refCnt) == 0) {
                throw new IllegalReferenceCountException(0, 1);
            }
            if (refCnt != Integer.MAX_VALUE) continue;
            throw new IllegalReferenceCountException(Integer.MAX_VALUE, 1);
        } while (!refCntUpdater.compareAndSet(this, refCnt, refCnt + 1));
        return this;
    }

    private void deallocate() {
        if (this.freed) {
            return;
        }
        this.freed = true;
        for (Component c : this.components) {
            c.buf.release();
        }
        this.components.clear();
        if (this.leak != null) {
            this.leak.close();
        }
    }

    private Component last() {
        if (this.components.isEmpty()) {
            return this.EMPTY_COMPONENT;
        }
        return this.components.get(this.components.size() - 1);
    }

    public int capacity() {
        Component last = this.last();
        return last.offset + last.buf.capacity();
    }

    public int maxCapacity() {
        return Integer.MAX_VALUE;
    }

    public AlternativeCompositeByteBuf capacity(int newCapacity) {
        return this.capacity(newCapacity, false);
    }

    public AlternativeCompositeByteBuf capacity(int newCapacity, boolean fillBuffer) {
        if (newCapacity < 0 || newCapacity > this.maxCapacity()) {
            throw new IllegalArgumentException("newCapacity: " + newCapacity);
        }
        int oldCapacity = this.capacity();
        if (newCapacity > oldCapacity) {
            int paddingLength = newCapacity - oldCapacity;
            this.addComponent(fillBuffer, this.allocBuffer(paddingLength));
        } else if (newCapacity < oldCapacity) {
            int bytesToTrim = oldCapacity - newCapacity;
            ListIterator<Component> i = this.components.listIterator(this.components.size());
            while (i.hasPrevious()) {
                Component c = i.previous();
                if (bytesToTrim >= c.buf.capacity()) {
                    bytesToTrim -= c.buf.capacity();
                    c.buf.release();
                    i.remove();
                    continue;
                }
                Component newC = new Component(c.buf.slice(0, c.buf.capacity() - bytesToTrim));
                newC.offset = c.offset;
                i.set(newC);
                break;
            }
        }
        if (this.readerIndex() > newCapacity) {
            this.setIndex(newCapacity, newCapacity);
        } else if (this.writerIndex() > newCapacity) {
            this.writerIndex(newCapacity);
        }
        return this;
    }

    private ByteBuf allocBuffer(int capacity) {
        if (this.direct) {
            return this.alloc().directBuffer(capacity);
        }
        return this.alloc().heapBuffer(capacity);
    }

    public AlternativeCompositeByteBuf addComponent(ByteBuf ... buffers) {
        return this.addComponent(false, buffers);
    }

    public AlternativeCompositeByteBuf addComponent(boolean fillBuffer, ByteBuf ... buffers) {
        if (buffers == null) {
            throw new NullPointerException("buffers");
        }
        for (ByteBuf b : buffers) {
            if (b == null) break;
            b.retain();
            Component c = new Component(b.order(ByteOrder.BIG_ENDIAN).duplicate());
            int size = this.components.size();
            this.components.add(c);
            if (size != 0) {
                Component prev = this.components.get(size - 1);
                c.offset = fillBuffer ? prev.offset + prev.buf.capacity() : prev.endOffset();
            }
            this.writerIndex0(this.writerIndex() + c.buf.writerIndex());
        }
        return this;
    }

    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    public AlternativeCompositeByteBuf order(ByteOrder endianness) {
        if (endianness == this.order()) {
            return this;
        }
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean isDirect() {
        return this.direct;
    }

    public int readerIndex() {
        return this.readerIndex;
    }

    public AlternativeCompositeByteBuf readerIndex(int readerIndex) {
        if (readerIndex < 0 || readerIndex > this.writerIndex) {
            throw new IndexOutOfBoundsException(String.format("readerIndex: %d (expected: 0 <= readerIndex <= writerIndex(%d))", readerIndex, this.writerIndex));
        }
        this.readerIndex = readerIndex;
        return this;
    }

    public int writerIndex() {
        return this.writerIndex;
    }

    public AlternativeCompositeByteBuf writerIndex(int writerIndex) {
        if (writerIndex < this.readerIndex || writerIndex > this.capacity()) {
            throw new IndexOutOfBoundsException(String.format("writerIndex: %d (expected: readerIndex(%d) <= writerIndex <= capacity(%d))", writerIndex, this.readerIndex, this.capacity()));
        }
        this.setComponentWriterIndex(writerIndex);
        return this;
    }

    private AlternativeCompositeByteBuf writerIndex0(int writerIndex) {
        if (writerIndex < this.readerIndex || writerIndex > this.capacity()) {
            throw new IndexOutOfBoundsException(String.format("writerIndex: %d (expected: readerIndex(%d) <= writerIndex <= capacity(%d))", writerIndex, this.readerIndex, this.capacity()));
        }
        this.writerIndex = writerIndex;
        return this;
    }

    public AlternativeCompositeByteBuf setIndex(int readerIndex, int writerIndex) {
        if (readerIndex < 0 || readerIndex > writerIndex || writerIndex > this.capacity()) {
            throw new IndexOutOfBoundsException(String.format("readerIndex: %d, writerIndex: %d (expected: 0 <= readerIndex <= writerIndex <= capacity(%d))", readerIndex, writerIndex, this.capacity()));
        }
        this.readerIndex = readerIndex;
        this.setComponentWriterIndex(writerIndex);
        return this;
    }

    private AlternativeCompositeByteBuf setIndex0(int readerIndex, int writerIndex) {
        if (readerIndex < 0 || readerIndex > writerIndex || writerIndex > this.capacity()) {
            throw new IndexOutOfBoundsException(String.format("readerIndex: %d, writerIndex: %d (expected: 0 <= readerIndex <= writerIndex <= capacity(%d))", readerIndex, writerIndex, this.capacity()));
        }
        this.readerIndex = readerIndex;
        this.writerIndex = writerIndex;
        return this;
    }

    public int readableBytes() {
        return this.writerIndex - this.readerIndex;
    }

    public int writableBytes() {
        return this.capacity() - this.writerIndex;
    }

    public int maxWritableBytes() {
        return this.maxCapacity() - this.writerIndex;
    }

    public boolean isReadable() {
        return this.writerIndex > this.readerIndex;
    }

    public boolean isReadable(int numBytes) {
        return this.writerIndex - this.readerIndex >= numBytes;
    }

    public boolean isWritable() {
        return this.capacity() > this.writerIndex;
    }

    public boolean isWritable(int numBytes) {
        return this.capacity() - this.writerIndex >= numBytes;
    }

    public ByteBuf unwrap() {
        return null;
    }

    public AlternativeCompositeByteBuf clear() {
        this.readerIndex = 0;
        this.setComponentWriterIndex(0);
        return this;
    }

    public AlternativeCompositeByteBuf markReaderIndex() {
        this.markedReaderIndex = this.readerIndex;
        return this;
    }

    public AlternativeCompositeByteBuf resetReaderIndex() {
        this.readerIndex(this.markedReaderIndex);
        return this;
    }

    public AlternativeCompositeByteBuf markWriterIndex() {
        this.markedWriterIndex = this.writerIndex;
        return this;
    }

    public AlternativeCompositeByteBuf resetWriterIndex() {
        this.setComponentWriterIndex(this.markedWriterIndex);
        return this;
    }

    public AlternativeCompositeByteBuf discardReadBytes() {
        return null;
    }

    public AlternativeCompositeByteBuf discardSomeReadBytes() {
        boolean isOffsetAdjustment = false;
        int offsetAdjustment = 0;
        Iterator<Component> iterator = this.components.iterator();
        while (iterator.hasNext()) {
            Component c = iterator.next();
            if (isOffsetAdjustment) {
                c.offset -= offsetAdjustment;
            }
            if (this.readerIndex >= c.endOffset()) {
                c.buf.release();
                iterator.remove();
                isOffsetAdjustment = true;
                int adjust = c.endOffset() - c.offset;
                this.setIndex0(this.readerIndex - adjust, this.writerIndex - adjust);
                offsetAdjustment += adjust;
                continue;
            }
            if (isOffsetAdjustment) continue;
            break;
        }
        return this;
    }

    public ByteBuf ensureWritable(int minWritableBytes) {
        return this.ensureWritable0(minWritableBytes, false);
    }

    public AlternativeCompositeByteBuf ensureWritable0(int minWritableBytes, boolean fillBuffer) {
        if (minWritableBytes < 0) {
            throw new IllegalArgumentException(String.format("minWritableBytes: %d (expected: >= 0)", minWritableBytes));
        }
        if (minWritableBytes <= this.writableBytes()) {
            return this;
        }
        if (minWritableBytes > this.maxCapacity() - this.writerIndex) {
            throw new IndexOutOfBoundsException(String.format("writerIndex(%d) + minWritableBytes(%d) exceeds maxCapacity(%d): %s", new Object[]{this.writerIndex, minWritableBytes, this.maxCapacity(), this}));
        }
        int newCapacity = this.calculateNewCapacity(this.writerIndex + minWritableBytes);
        this.capacity(newCapacity, fillBuffer);
        return this;
    }

    private int calculateNewCapacity(int minNewCapacity) {
        int newCapacity;
        int maxCapacity = this.maxCapacity();
        int threshold = 0x400000;
        if (minNewCapacity == 0x400000) {
            return 0x400000;
        }
        if (minNewCapacity > 0x400000) {
            int newCapacity2 = minNewCapacity / 0x400000 * 0x400000;
            newCapacity2 = newCapacity2 > maxCapacity - 0x400000 ? maxCapacity : (newCapacity2 += 0x400000);
            return newCapacity2;
        }
        for (newCapacity = 64; newCapacity < minNewCapacity; newCapacity <<= 1) {
        }
        return Math.min(newCapacity, maxCapacity);
    }

    public int ensureWritable(int minWritableBytes, boolean force) {
        if (minWritableBytes < 0) {
            throw new IllegalArgumentException(String.format("minWritableBytes: %d (expected: >= 0)", minWritableBytes));
        }
        if (minWritableBytes <= this.writableBytes()) {
            return 0;
        }
        if (minWritableBytes > this.maxCapacity() - this.writerIndex && force) {
            if (this.capacity() == this.maxCapacity()) {
                return 1;
            }
            this.capacity(this.maxCapacity());
            return 3;
        }
        int newCapacity = this.calculateNewCapacity(this.writerIndex + minWritableBytes);
        this.capacity(newCapacity);
        return 2;
    }

    private final void checkIndex(int index) {
        if (index < 0 || index > this.capacity()) {
            throw new IndexOutOfBoundsException(String.format("index: %d (expected: range(0, %d))", index, this.capacity()));
        }
    }

    private final void checkIndex(int index, int fieldLength) {
        if (fieldLength < 0) {
            throw new IllegalArgumentException("length: " + fieldLength + " (expected: >= 0)");
        }
        if (index < 0 || index > this.capacity() - fieldLength) {
            throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", index, fieldLength, this.capacity()));
        }
    }

    private Component findComponent(int offset) {
        this.checkIndex(offset);
        Component last = this.last();
        if (offset >= last.offset) {
            return last;
        }
        ListIterator<Component> i = this.components.listIterator(this.components.size() - 1);
        while (i.hasPrevious()) {
            Component c = i.previous();
            if (offset < c.offset) continue;
            return c;
        }
        throw new Error("should not happen");
    }

    private int findIndex(int offset) {
        this.checkIndex(offset);
        Component last = this.last();
        if (offset >= last.offset) {
            return this.components.size() - 1;
        }
        int index = this.components.size() - 2;
        ListIterator<Component> i = this.components.listIterator(this.components.size() - 1);
        while (i.hasPrevious()) {
            Component c = i.previous();
            if (offset >= c.offset) {
                return index;
            }
            --index;
        }
        throw new Error("should not happen");
    }

    public boolean getBoolean(int index) {
        return this.getByte(index) != 0;
    }

    public byte getByte(int index) {
        Component c = this.findComponent(index);
        return c.buf.getByte(index - c.offset);
    }

    public short getUnsignedByte(int index) {
        return (short)(this.getByte(index) & 0xFF);
    }

    public short getShort(int index) {
        Component c = this.findComponent(index);
        if (index + 2 <= c.endOffset()) {
            return c.buf.getShort(index - c.offset);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)((this.getByte(index) & 0xFF) << 8 | this.getByte(index + 1) & 0xFF);
        }
        return (short)(this.getByte(index) & 0xFF | (this.getByte(index + 1) & 0xFF) << 8);
    }

    public int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFFF;
    }

    public int getMedium(int index) {
        int value = this.getUnsignedMedium(index);
        if ((value & 0x800000) != 0) {
            value |= 0xFF000000;
        }
        return value;
    }

    public int getUnsignedMedium(int index) {
        Component c = this.findComponent(index);
        if (index + 3 <= c.endOffset()) {
            return c.buf.getUnsignedMedium(index - c.offset);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this.getShort(index) & 0xFFFF) << 8 | this.getByte(index + 2) & 0xFF;
        }
        return this.getShort(index) & 0xFFFF | (this.getByte(index + 2) & 0xFF) << 16;
    }

    public int getInt(int index) {
        Component c = this.findComponent(index);
        if (index + 4 <= c.endOffset()) {
            return c.buf.getInt(index - c.offset);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this.getShort(index) & 0xFFFF) << 16 | this.getShort(index + 2) & 0xFFFF;
        }
        return this.getShort(index) & 0xFFFF | (this.getShort(index + 2) & 0xFFFF) << 16;
    }

    public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    public long getLong(int index) {
        Component c = this.findComponent(index);
        if (index + 8 <= c.endOffset()) {
            return c.buf.getLong(index - c.offset);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this.getInt(index) & 0xFFFFFFFFL) << 32 | (long)this.getInt(index + 4) & 0xFFFFFFFFL;
        }
        return (long)this.getInt(index) & 0xFFFFFFFFL | ((long)this.getInt(index + 4) & 0xFFFFFFFFL) << 32;
    }

    public char getChar(int index) {
        return (char)this.getShort(index);
    }

    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    private final void checkDstIndex(int index, int length, int dstIndex, int dstCapacity) {
        this.checkIndex(index, length);
        if (dstIndex < 0 || dstIndex > dstCapacity - length) {
            throw new IndexOutOfBoundsException(String.format("dstIndex: %d, length: %d (expected: range(0, %d))", dstIndex, length, dstCapacity));
        }
    }

    private final void checkSrcIndex(int index, int length, int srcIndex, int srcCapacity) {
        this.checkIndex(index, length);
        if (srcIndex < 0 || srcIndex > srcCapacity - length) {
            throw new IndexOutOfBoundsException(String.format("srcIndex: %d, length: %d (expected: range(0, %d))", srcIndex, length, srcCapacity));
        }
    }

    public AlternativeCompositeByteBuf getBytes(int index, ByteBuf dst) {
        this.getBytes(index, dst, dst.writableBytes());
        return this;
    }

    public AlternativeCompositeByteBuf getBytes(int index, ByteBuf dst, int length) {
        this.getBytes(index, dst, dst.writerIndex(), length);
        dst.writerIndex(dst.writerIndex() + length);
        return this;
    }

    public AlternativeCompositeByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.capacity());
        if (length == 0) {
            return this;
        }
        int i = this.findIndex(index);
        while (length > 0) {
            Component c = this.components.get(i);
            ByteBuf s = c.buf;
            int adjustment = c.offset;
            int localLength = Math.min(length, s.readableBytes() - (index - adjustment));
            s.getBytes(index - adjustment, dst, dstIndex, localLength);
            index += localLength;
            dstIndex += localLength;
            length -= localLength;
            ++i;
        }
        return this;
    }

    public AlternativeCompositeByteBuf getBytes(int index, byte[] dst) {
        this.getBytes(index, dst, 0, dst.length);
        return this;
    }

    public AlternativeCompositeByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.length);
        if (length == 0) {
            return this;
        }
        int i = this.findIndex(index);
        while (length > 0) {
            Component c = this.components.get(i);
            ByteBuf s = c.buf;
            int adjustment = c.offset;
            int localLength = Math.min(length, s.readableBytes() - (index - adjustment));
            s.getBytes(index - adjustment, dst, dstIndex, localLength);
            index += localLength;
            dstIndex += localLength;
            length -= localLength;
            ++i;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlternativeCompositeByteBuf getBytes(int index, ByteBuffer dst) {
        int limit = dst.limit();
        int length = dst.remaining();
        this.checkIndex(index, length);
        if (length == 0) {
            return this;
        }
        int i = this.findIndex(index);
        try {
            while (length > 0) {
                Component c = this.components.get(i);
                ByteBuf s = c.buf;
                int adjustment = c.offset;
                int localLength = Math.min(length, s.readableBytes() - (index - adjustment));
                dst.limit(dst.position() + localLength);
                s.getBytes(index - adjustment, dst);
                index += localLength;
                length -= localLength;
                ++i;
            }
        }
        finally {
            dst.limit(limit);
        }
        return this;
    }

    public AlternativeCompositeByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.checkIndex(index, length);
        if (length == 0) {
            return this;
        }
        int i = this.findIndex(index);
        while (length > 0) {
            Component c = this.components.get(i);
            ByteBuf s = c.buf;
            int adjustment = c.offset;
            int localLength = Math.min(length, s.readableBytes() - (index - adjustment));
            s.getBytes(index - adjustment, out, localLength);
            index += localLength;
            length -= localLength;
            ++i;
        }
        return this;
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        int count = this.nioBufferCount();
        if (count == 1) {
            return out.write(this.internalNioBuffer(index, length));
        }
        long writtenBytes = out.write(this.nioBuffers(index, length));
        if (writtenBytes > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)writtenBytes;
    }

    public AlternativeCompositeByteBuf setBoolean(int index, boolean value) {
        this.setByte(index, value ? 1 : 0);
        return this;
    }

    public AlternativeCompositeByteBuf setByte(int index, int value) {
        Component c = this.findComponent(index);
        c.buf.setByte(index - c.offset, value);
        return this;
    }

    public AlternativeCompositeByteBuf setShort(int index, int value) {
        Component c = this.findComponent(index);
        if (index + 2 <= c.endOffset()) {
            c.buf.setShort(index - c.offset, value);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setByte(index, (byte)(value >>> 8));
            this.setByte(index + 1, (byte)value);
        } else {
            this.setByte(index, (byte)value);
            this.setByte(index + 1, (byte)(value >>> 8));
        }
        return this;
    }

    public AlternativeCompositeByteBuf setMedium(int index, int value) {
        Component c = this.findComponent(index);
        if (index + 3 <= c.endOffset()) {
            c.buf.setMedium(index - c.offset, value);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setShort(index, (short)(value >> 8));
            this.setByte(index + 2, (byte)value);
        } else {
            this.setShort(index, (short)value);
            this.setByte(index + 2, (byte)(value >>> 16));
        }
        return this;
    }

    public AlternativeCompositeByteBuf setInt(int index, int value) {
        Component c = this.findComponent(index);
        if (index + 4 <= c.endOffset()) {
            c.buf.setInt(index - c.offset, value);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setShort(index, (short)(value >>> 16));
            this.setShort(index + 2, (short)value);
        } else {
            this.setShort(index, (short)value);
            this.setShort(index + 2, (short)(value >>> 16));
        }
        return this;
    }

    public AlternativeCompositeByteBuf setLong(int index, long value) {
        Component c = this.findComponent(index);
        if (index + 8 <= c.endOffset()) {
            c.buf.setLong(index - c.offset, value);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setInt(index, (int)(value >>> 32));
            this.setInt(index + 4, (int)value);
        } else {
            this.setInt(index, (int)value);
            this.setInt(index + 4, (int)(value >>> 32));
        }
        return this;
    }

    public AlternativeCompositeByteBuf setChar(int index, int value) {
        this.setShort(index, value);
        return this;
    }

    public AlternativeCompositeByteBuf setFloat(int index, float value) {
        this.setInt(index, Float.floatToRawIntBits(value));
        return this;
    }

    public AlternativeCompositeByteBuf setDouble(int index, double value) {
        this.setLong(index, Double.doubleToRawLongBits(value));
        return this;
    }

    public AlternativeCompositeByteBuf setBytes(int index, ByteBuf src) {
        this.setBytes(index, src, src.readableBytes());
        return this;
    }

    public AlternativeCompositeByteBuf setBytes(int index, ByteBuf src, int length) {
        this.checkIndex(index, length);
        if (src == null) {
            throw new NullPointerException("src");
        }
        if (length > src.readableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds src.readableBytes(%d) where src is: %s", length, src.readableBytes(), src));
        }
        this.setBytes(index, src, src.readerIndex(), length);
        src.readerIndex(src.readerIndex() + length);
        return this;
    }

    public AlternativeCompositeByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.checkSrcIndex(index, length, srcIndex, src.capacity());
        if (length == 0) {
            return this;
        }
        int i = this.findIndex(index);
        while (length > 0) {
            Component c = this.components.get(i);
            ByteBuf s = c.buf;
            int adjustment = c.offset;
            int localLength = Math.min(length, s.writableBytes());
            s.setBytes(index - adjustment, src, srcIndex, localLength);
            index += localLength;
            srcIndex += localLength;
            length -= localLength;
            ++i;
        }
        return this;
    }

    public AlternativeCompositeByteBuf setBytes(int index, byte[] src) {
        this.setBytes(index, src, 0, src.length);
        return this;
    }

    public AlternativeCompositeByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.checkSrcIndex(index, length, srcIndex, src.length);
        if (length == 0) {
            return this;
        }
        int i = this.findIndex(index);
        while (length > 0) {
            Component c = this.components.get(i);
            ByteBuf s = c.buf;
            int adjustment = c.offset;
            int localLength = Math.min(length, s.writableBytes());
            s.setBytes(index - adjustment, src, srcIndex, localLength);
            index += localLength;
            srcIndex += localLength;
            length -= localLength;
            ++i;
        }
        return this;
    }

    public boolean sync() {
        int counter = 0;
        for (Component c : this.components) {
            counter += c.buf.writerIndex();
        }
        return counter == this.writerIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlternativeCompositeByteBuf setBytes(int index, ByteBuffer src) {
        int limit = src.limit();
        int length = src.remaining();
        this.checkIndex(index, length);
        if (length == 0) {
            return this;
        }
        int i = this.findIndex(index);
        try {
            while (length > 0) {
                Component c = this.components.get(i);
                ByteBuf s = c.buf;
                int adjustment = c.offset;
                int localLength = Math.min(length, s.writableBytes());
                src.limit(src.position() + localLength);
                s.setBytes(index - adjustment, src);
                index += localLength;
                length -= localLength;
                ++i;
            }
        }
        finally {
            src.limit(limit);
        }
        return this;
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        this.checkIndex(index, length);
        if (length == 0) {
            return in.read(EmptyArrays.EMPTY_BYTES);
        }
        int i = this.findIndex(index);
        int readBytes = 0;
        do {
            Component c = this.components.get(i);
            ByteBuf s = c.buf;
            int adjustment = c.offset;
            int localLength = Math.min(length, s.writableBytes());
            int localReadBytes = s.setBytes(index - adjustment, in, localLength);
            if (localReadBytes < 0) {
                if (readBytes != 0) break;
                return -1;
            }
            if (localReadBytes == localLength) {
                index += localLength;
                length -= localLength;
                readBytes += localLength;
                ++i;
                continue;
            }
            index += localReadBytes;
            length -= localReadBytes;
            readBytes += localReadBytes;
        } while (length > 0);
        return readBytes;
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        this.checkIndex(index, length);
        if (length == 0) {
            return in.read(FULL_BYTEBUFFER);
        }
        int i = this.findIndex(index);
        int readBytes = 0;
        do {
            Component c = this.components.get(i);
            ByteBuf s = c.buf;
            int adjustment = c.offset;
            int localLength = Math.min(length, s.writableBytes());
            int localReadBytes = s.setBytes(index - adjustment, in, localLength);
            if (localReadBytes == 0) break;
            if (localReadBytes < 0) {
                if (readBytes != 0) break;
                return -1;
            }
            if (localReadBytes == localLength) {
                index += localLength;
                length -= localLength;
                readBytes += localLength;
                ++i;
                continue;
            }
            index += localReadBytes;
            length -= localReadBytes;
            readBytes += localReadBytes;
        } while (length > 0);
        return readBytes;
    }

    public AlternativeCompositeByteBuf setZero(int index, int length) {
        int i;
        if (length == 0) {
            return this;
        }
        this.checkIndex(index, length);
        int nLong = length >>> 3;
        int nBytes = length & 7;
        for (i = nLong; i > 0; --i) {
            this.setLong(index, 0L);
            index += 8;
        }
        if (nBytes == 4) {
            this.setInt(index, 0);
        } else if (nBytes < 4) {
            for (i = nBytes; i > 0; --i) {
                this.setByte(index, 0);
                ++index;
            }
        } else {
            this.setInt(index, 0);
            index += 4;
            for (i = nBytes - 4; i > 0; --i) {
                this.setByte(index, 0);
                ++index;
            }
        }
        return this;
    }

    private final void checkReadableBytes(int minimumReadableBytes) {
        if (minimumReadableBytes < 0) {
            throw new IllegalArgumentException("minimumReadableBytes: " + minimumReadableBytes + " (expected: >= 0)");
        }
        if (this.readerIndex > this.writerIndex - minimumReadableBytes) {
            throw new IndexOutOfBoundsException(String.format("readerIndex(%d) + length(%d) exceeds writerIndex(%d): %s", new Object[]{this.readerIndex, minimumReadableBytes, this.writerIndex, this}));
        }
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public byte readByte() {
        this.checkReadableBytes(1);
        int i = this.readerIndex;
        byte b = this.getByte(i);
        this.readerIndex = i + 1;
        return b;
    }

    public short readUnsignedByte() {
        return (short)(this.readByte() & 0xFF);
    }

    public short readShort() {
        this.checkReadableBytes(2);
        short v = this.getShort(this.readerIndex);
        this.readerIndex += 2;
        return v;
    }

    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    public int readMedium() {
        int value = this.readUnsignedMedium();
        if ((value & 0x800000) != 0) {
            value |= 0xFF000000;
        }
        return value;
    }

    public int readUnsignedMedium() {
        this.checkReadableBytes(3);
        int v = this.getUnsignedMedium(this.readerIndex);
        this.readerIndex += 3;
        return v;
    }

    public int readInt() {
        this.checkReadableBytes(4);
        int v = this.getInt(this.readerIndex);
        this.readerIndex += 4;
        return v;
    }

    public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readLong() {
        this.checkReadableBytes(8);
        long v = this.getLong(this.readerIndex);
        this.readerIndex += 8;
        return v;
    }

    public char readChar() {
        return (char)this.readShort();
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public ByteBuf readBytes(int length) {
        this.checkReadableBytes(length);
        if (length == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf buf = Unpooled.buffer((int)length, (int)this.maxCapacity());
        buf.writeBytes((ByteBuf)this, this.readerIndex, length);
        this.readerIndex += length;
        return buf;
    }

    public ByteBuf readSlice(int length) {
        ByteBuf slice = this.slice(this.readerIndex, length);
        this.readerIndex += length;
        return slice;
    }

    public ByteBuf readBytes(ByteBuf dst) {
        this.readBytes(dst, dst.writableBytes());
        return this;
    }

    public ByteBuf readBytes(ByteBuf dst, int length) {
        if (length > dst.writableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds dst.writableBytes(%d) where dst is: %s", length, dst.writableBytes(), dst));
        }
        this.readBytes(dst, dst.writerIndex(), length);
        dst.writerIndex(dst.writerIndex() + length);
        return this;
    }

    public ByteBuf readBytes(ByteBuf dst, int dstIndex, int length) {
        this.checkReadableBytes(length);
        this.getBytes(this.readerIndex, dst, dstIndex, length);
        this.readerIndex += length;
        return this;
    }

    public ByteBuf readBytes(byte[] dst) {
        this.readBytes(dst, 0, dst.length);
        return this;
    }

    public ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        this.checkReadableBytes(length);
        this.getBytes(this.readerIndex, dst, dstIndex, length);
        this.readerIndex += length;
        return this;
    }

    public ByteBuf readBytes(ByteBuffer dst) {
        int length = dst.remaining();
        this.checkReadableBytes(length);
        this.getBytes(this.readerIndex, dst);
        this.readerIndex += length;
        return this;
    }

    public ByteBuf readBytes(OutputStream out, int length) throws IOException {
        this.checkReadableBytes(length);
        this.getBytes(this.readerIndex, out, length);
        this.readerIndex += length;
        return this;
    }

    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        this.checkReadableBytes(length);
        int readBytes = this.getBytes(this.readerIndex, out, length);
        this.readerIndex += readBytes;
        return readBytes;
    }

    public ByteBuf skipBytes(int length) {
        this.checkReadableBytes(length);
        int newReaderIndex = this.readerIndex + length;
        if (newReaderIndex > this.writerIndex) {
            throw new IndexOutOfBoundsException(String.format("length: %d (expected: readerIndex(%d) + length <= writerIndex(%d))", length, this.readerIndex, this.writerIndex));
        }
        this.readerIndex = newReaderIndex;
        return this;
    }

    private void setComponentWriterIndex(int writerIndex) {
        int index = this.findIndex(writerIndex);
        int to = this.findIndex(this.writerIndex);
        Component c = this.components.get(index);
        int relWriterIndex = writerIndex - c.offset;
        c.buf.writerIndex(relWriterIndex);
        if (this.writerIndex < writerIndex) {
            for (int i = index - 1; i > to; --i) {
                c = this.components.get(i);
                c.buf.writerIndex(c.buf.capacity());
            }
            this.writerIndex = writerIndex;
        } else {
            for (int i = index + 1; i < to; ++i) {
                this.components.get((int)i).buf.writerIndex(0);
            }
            this.writerIndex = writerIndex;
        }
    }

    private void increaseComponentWriterIndex(int increase) {
        int maxIncrease = 0;
        int currentIncrease = increase;
        int index = this.findIndex(this.writerIndex);
        while (maxIncrease < increase) {
            Component c = this.components.get(index);
            int writable = c.buf.writableBytes();
            writable = Math.min(writable, currentIncrease);
            c.buf.writerIndex(c.buf.writerIndex() + writable);
            currentIncrease -= writable;
            maxIncrease += writable;
            ++index;
        }
        this.writerIndex += increase;
    }

    public ByteBuf writeBoolean(boolean value) {
        this.writeByte(value ? 1 : 0);
        return this;
    }

    public ByteBuf writeByte(int value) {
        this.ensureWritable0(1, true);
        this.setByte(this.writerIndex, value);
        this.increaseComponentWriterIndex(1);
        return this;
    }

    public ByteBuf writeShort(int value) {
        this.ensureWritable0(2, true);
        this.setShort(this.writerIndex, value);
        this.increaseComponentWriterIndex(2);
        return this;
    }

    public ByteBuf writeMedium(int value) {
        this.ensureWritable0(3, true);
        this.setMedium(this.writerIndex, value);
        this.increaseComponentWriterIndex(3);
        return this;
    }

    public ByteBuf writeInt(int value) {
        this.ensureWritable0(4, true);
        this.setInt(this.writerIndex, value);
        this.increaseComponentWriterIndex(4);
        return this;
    }

    public ByteBuf writeLong(long value) {
        this.ensureWritable0(8, true);
        this.setLong(this.writerIndex, value);
        this.increaseComponentWriterIndex(8);
        return this;
    }

    public ByteBuf writeChar(int value) {
        this.writeShort(value);
        return this;
    }

    public ByteBuf writeFloat(float value) {
        this.writeInt(Float.floatToRawIntBits(value));
        return this;
    }

    public ByteBuf writeDouble(double value) {
        this.writeLong(Double.doubleToRawLongBits(value));
        return this;
    }

    public ByteBuf writeBytes(ByteBuf src) {
        this.writeBytes(src, src.readableBytes());
        return this;
    }

    public ByteBuf writeBytes(ByteBuf src, int length) {
        if (length > src.readableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds src.readableBytes(%d) where src is: %s", length, src.readableBytes(), src));
        }
        this.writeBytes(src, src.readerIndex(), length);
        src.readerIndex(src.readerIndex() + length);
        return this;
    }

    public ByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
        this.ensureWritable0(length, true);
        this.setBytes(this.writerIndex, src, srcIndex, length);
        this.increaseComponentWriterIndex(length);
        return this;
    }

    public ByteBuf writeBytes(byte[] src) {
        this.writeBytes(src, 0, src.length);
        return this;
    }

    public ByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        this.ensureWritable0(length, true);
        this.setBytes(this.writerIndex, src, srcIndex, length);
        this.increaseComponentWriterIndex(length);
        return this;
    }

    public ByteBuf writeBytes(ByteBuffer src) {
        int length = src.remaining();
        this.ensureWritable0(length, true);
        this.setBytes(this.writerIndex, src);
        this.increaseComponentWriterIndex(length);
        return this;
    }

    public int writeBytes(InputStream in, int length) throws IOException {
        this.ensureWritable0(length, true);
        int writtenBytes = this.setBytes(this.writerIndex, in, length);
        if (writtenBytes > 0) {
            this.increaseComponentWriterIndex(writtenBytes);
        }
        return writtenBytes;
    }

    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        this.ensureWritable0(length, true);
        int writtenBytes = this.setBytes(this.writerIndex, in, length);
        if (writtenBytes > 0) {
            this.increaseComponentWriterIndex(writtenBytes);
        }
        return writtenBytes;
    }

    public ByteBuf writeZero(int length) {
        int i;
        if (length == 0) {
            return this;
        }
        this.ensureWritable0(length, true);
        this.checkIndex(this.writerIndex, length);
        int nLong = length >>> 3;
        int nBytes = length & 7;
        for (i = nLong; i > 0; --i) {
            this.writeLong(0L);
        }
        if (nBytes == 4) {
            this.writeInt(0);
        } else if (nBytes < 4) {
            for (i = nBytes; i > 0; --i) {
                this.writeByte(0);
            }
        } else {
            this.writeInt(0);
            for (i = nBytes - 4; i > 0; --i) {
                this.writeByte(0);
            }
        }
        return this;
    }

    public int indexOf(int fromIndex, int toIndex, byte value) {
        return ByteBufUtil.indexOf((ByteBuf)this, (int)fromIndex, (int)toIndex, (byte)value);
    }

    public int bytesBefore(byte value) {
        return this.bytesBefore(this.readerIndex(), this.readableBytes(), value);
    }

    public int bytesBefore(int length, byte value) {
        this.checkReadableBytes(length);
        return this.bytesBefore(this.readerIndex(), length, value);
    }

    public int bytesBefore(int index, int length, byte value) {
        int endIndex = this.indexOf(index, index + length, value);
        if (endIndex < 0) {
            return -1;
        }
        return endIndex - index;
    }

    public int forEachByte(ByteBufProcessor processor) {
        int index = this.readerIndex;
        int length = this.writerIndex - index;
        return this.forEachByteAsc0(index, length, processor);
    }

    public int forEachByte(int index, int length, ByteBufProcessor processor) {
        this.checkIndex(index, length);
        return this.forEachByteAsc0(index, length, processor);
    }

    private int forEachByteAsc0(int index, int length, ByteBufProcessor processor) {
        if (processor == null) {
            throw new NullPointerException("processor");
        }
        if (length == 0) {
            return -1;
        }
        int endIndex = index + length;
        int i = index;
        try {
            do {
                if (processor.process(this.getByte(i))) continue;
                return i;
            } while (++i < endIndex);
        }
        catch (Exception e) {
            PlatformDependent.throwException((Throwable)e);
        }
        return -1;
    }

    public int forEachByteDesc(ByteBufProcessor processor) {
        int index = this.readerIndex;
        int length = this.writerIndex - index;
        return this.forEachByteDesc0(index, length, processor);
    }

    public int forEachByteDesc(int index, int length, ByteBufProcessor processor) {
        this.checkIndex(index, length);
        return this.forEachByteDesc0(index, length, processor);
    }

    private int forEachByteDesc0(int index, int length, ByteBufProcessor processor) {
        if (processor == null) {
            throw new NullPointerException("processor");
        }
        if (length == 0) {
            return -1;
        }
        int i = index + length - 1;
        try {
            do {
                if (processor.process(this.getByte(i))) continue;
                return i;
            } while (--i >= index);
        }
        catch (Exception e) {
            PlatformDependent.throwException((Throwable)e);
        }
        return -1;
    }

    public ByteBuf copy() {
        return this.copy(this.readerIndex, this.readableBytes());
    }

    public ByteBuf copy(int index, int length) {
        this.checkIndex(index, length);
        ByteBuf dst = Unpooled.buffer((int)length);
        if (length != 0) {
            this.copyTo(index, length, this.findIndex(index), dst);
        }
        return dst;
    }

    private void copyTo(int index, int length, int componentId, ByteBuf dst) {
        int dstIndex = 0;
        int i = componentId;
        while (length > 0) {
            Component c = this.components.get(i);
            ByteBuf s = c.buf;
            int adjustment = c.offset;
            int localLength = Math.min(length, s.readableBytes() - (index - adjustment));
            s.getBytes(index - adjustment, dst, dstIndex, localLength);
            index += localLength;
            dstIndex += localLength;
            length -= localLength;
            ++i;
        }
        dst.writerIndex(dst.capacity());
    }

    public ByteBuf slice() {
        return this.slice(this.readerIndex, this.readableBytes());
    }

    public ByteBuf slice(int index, int length) {
        if (length == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        return new SlicedByteBuf((ByteBuf)this, index, length);
    }

    public ByteBuf duplicate() {
        return new DuplicatedByteBuf((ByteBuf)this);
    }

    public int nioBufferCount() {
        if (this.components.size() == 1) {
            return this.components.get((int)0).buf.nioBufferCount();
        }
        int count = 0;
        int componentsCount = this.components.size();
        for (int i = 0; i < componentsCount; ++i) {
            Component c = this.components.get(i);
            count += c.buf.nioBufferCount();
        }
        return count;
    }

    public ByteBuffer nioBuffer() {
        return this.nioBuffer(this.readerIndex, this.readableBytes());
    }

    public ByteBuffer nioBuffer(int index, int length) {
        ByteBuf buf;
        if (this.components.size() == 1 && (buf = this.components.get((int)0).buf).nioBufferCount() == 1) {
            return this.components.get((int)0).buf.nioBuffer(index, length);
        }
        ByteBuffer merged = ByteBuffer.allocate(length).order(this.order());
        ByteBuffer[] buffers = this.nioBuffers(index, length);
        for (int i = 0; i < buffers.length; ++i) {
            merged.put(buffers[i]);
        }
        merged.flip();
        return merged;
    }

    public ByteBuffer internalNioBuffer(int index, int length) {
        if (this.components.size() == 1) {
            return this.components.get((int)0).buf.internalNioBuffer(index, length);
        }
        throw new UnsupportedOperationException();
    }

    public ByteBuffer[] nioBuffers() {
        return this.nioBuffers(this.readerIndex, this.readableBytes());
    }

    public ByteBuffer[] nioBuffers(int index, int length) {
        this.checkIndex(index, length);
        if (length == 0) {
            return EmptyArrays.EMPTY_BYTE_BUFFERS;
        }
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.components.size());
        int i = this.findIndex(index);
        while (length > 0) {
            Component c = this.components.get(i);
            ByteBuf s = c.buf;
            int adjustment = c.offset;
            int localLength = Math.min(length, s.readableBytes() - (index - adjustment));
            switch (s.nioBufferCount()) {
                case 0: {
                    throw new UnsupportedOperationException();
                }
                case 1: {
                    buffers.add(s.nioBuffer(index - adjustment, localLength));
                    break;
                }
                default: {
                    Collections.addAll(buffers, s.nioBuffers(index - adjustment, localLength));
                }
            }
            index += localLength;
            length -= localLength;
            ++i;
        }
        return buffers.toArray(new ByteBuffer[buffers.size()]);
    }

    public boolean hasArray() {
        if (this.components.size() == 1) {
            return this.components.get((int)0).buf.hasArray();
        }
        return false;
    }

    public byte[] array() {
        if (this.components.size() == 1) {
            return this.components.get((int)0).buf.array();
        }
        throw new UnsupportedOperationException();
    }

    public int arrayOffset() {
        if (this.components.size() == 1) {
            return this.components.get((int)0).buf.arrayOffset();
        }
        throw new UnsupportedOperationException();
    }

    public boolean hasMemoryAddress() {
        if (this.components.size() == 1) {
            return this.components.get((int)0).buf.hasMemoryAddress();
        }
        return false;
    }

    public long memoryAddress() {
        if (this.components.size() == 1) {
            return this.components.get((int)0).buf.memoryAddress();
        }
        throw new UnsupportedOperationException();
    }

    public String toString(Charset charset) {
        return this.toString(this.readerIndex, this.readableBytes(), charset);
    }

    public String toString(int index, int length, Charset charset) {
        ByteBuffer nioBuffer;
        if (length == 0) {
            return "";
        }
        if (this.nioBufferCount() == 1) {
            nioBuffer = this.nioBuffer(index, length);
        } else {
            nioBuffer = ByteBuffer.allocate(length);
            this.getBytes(index, nioBuffer);
            nioBuffer.flip();
        }
        return AlternativeCompositeByteBuf.decodeString(nioBuffer, charset);
    }

    public int hashCode() {
        return ByteBufUtil.hashCode((ByteBuf)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ByteBuf) {
            return ByteBufUtil.equals((ByteBuf)this, (ByteBuf)((ByteBuf)o));
        }
        return false;
    }

    public int compareTo(ByteBuf that) {
        return ByteBufUtil.compare((ByteBuf)this, (ByteBuf)that);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(StringUtil.simpleClassName((Object)((Object)this)));
        buf.append("(ridx: ");
        buf.append(this.readerIndex);
        buf.append(", widx: ");
        buf.append(this.writerIndex);
        buf.append(", cap: ");
        buf.append(this.capacity());
        buf.append(", comp: ");
        buf.append(this.components.size());
        buf.append(')');
        return buf.toString();
    }

    public List<ByteBuf> decompose(int offset, int length) {
        int readableBytes;
        this.checkIndex(offset, length);
        if (length == 0) {
            return Collections.emptyList();
        }
        int componentId = this.findIndex(offset);
        ArrayList<ByteBuf> slice = new ArrayList<ByteBuf>(this.components.size());
        Component firstC = this.components.get(componentId);
        ByteBuf first = firstC.buf.duplicate();
        first.readerIndex(offset - firstC.offset);
        ByteBuf buf = first;
        int bytesToSlice = length;
        do {
            if (bytesToSlice <= (readableBytes = buf.readableBytes())) {
                buf.writerIndex(buf.readerIndex() + bytesToSlice);
                slice.add(buf);
                break;
            }
            slice.add(buf);
            buf = this.components.get((int)(++componentId)).buf.duplicate();
        } while ((bytesToSlice -= readableBytes) > 0);
        for (int i = 0; i < slice.size(); ++i) {
            slice.set(i, ((ByteBuf)slice.get(i)).slice());
        }
        return slice;
    }

    private static String decodeString(ByteBuffer src, Charset charset) {
        CharsetDecoder decoder = CharsetUtil.getDecoder((Charset)charset);
        CharBuffer dst = CharBuffer.allocate((int)((double)src.remaining() * (double)decoder.maxCharsPerByte()));
        try {
            CoderResult cr = decoder.decode(src, dst, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = decoder.flush(dst)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new IllegalStateException(x);
        }
        return dst.flip().toString();
    }

    public static AlternativeCompositeByteBuf compBuffer(ByteBufAllocator alloc, boolean direct, ByteBuf ... buffers) {
        return new AlternativeCompositeByteBuf(alloc, direct, buffers);
    }

    public static AlternativeCompositeByteBuf compBuffer(boolean direct) {
        return AlternativeCompositeByteBuf.compBuffer(ALLOC, direct, new ByteBuf[0]);
    }

    public static AlternativeCompositeByteBuf compBuffer() {
        return AlternativeCompositeByteBuf.compBuffer(false);
    }

    public static AlternativeCompositeByteBuf compDirectBuffer() {
        return AlternativeCompositeByteBuf.compBuffer(true);
    }

    public static AlternativeCompositeByteBuf compDirectBuffer(ByteBuf ... buffers) {
        return AlternativeCompositeByteBuf.compBuffer(ALLOC, true, buffers);
    }

    public static AlternativeCompositeByteBuf compBuffer(ByteBuf ... buffers) {
        return AlternativeCompositeByteBuf.compBuffer(ALLOC, false, buffers);
    }

    private final class Component {
        final ByteBuf buf;
        int offset;

        Component(ByteBuf buf) {
            this.buf = buf;
        }

        int endOffset() {
            return this.offset + this.buf.readableBytes();
        }
    }
}

