/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.tracker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.message.TrackerData;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.Data;
import net.tomp2p.tracker.FutureTracker;

public class UtilsTracker {
    public static TrackerData limit(TrackerData peers, int size) {
        HashMap<PeerAddress, Data> retVal = new HashMap<PeerAddress, Data>(size);
        Random random = new Random();
        ArrayList keys = new ArrayList(peers.peerAddresses().keySet());
        for (int i = 0; i < size && !keys.isEmpty(); ++i) {
            PeerAddress key = (PeerAddress)keys.get(random.nextInt(keys.size()));
            Data value = (Data)peers.peerAddresses().get(key);
            if (value != null) {
                retVal.put(key, value);
                continue;
            }
            --i;
        }
        TrackerData data = new TrackerData(retVal, peers.peerAddresses().size() > size);
        return data;
    }

    public static TrackerData disjunction(TrackerData meshPeers, SimpleBloomFilter<Number160> knownPeers) {
        TrackerData trackerData = new TrackerData(new HashMap());
        for (Map.Entry entry : meshPeers.peerAddresses().entrySet()) {
            if (knownPeers.contains((Object)((PeerAddress)entry.getKey()).peerId())) continue;
            trackerData.put((PeerAddress)entry.getKey(), (Data)entry.getValue());
        }
        return trackerData;
    }

    public static void addReleaseListener(final ChannelCreator channelCreator, final FutureTracker futureTracker) {
        if (futureTracker == null) {
            channelCreator.shutdown();
            return;
        }
        futureTracker.addListener((BaseFutureListener)new BaseFutureAdapter<FutureTracker>(){

            public void operationComplete(FutureTracker future) throws Exception {
                FutureDone<Void> futuresCompleted = futureTracker.futuresCompleted();
                if (futuresCompleted != null) {
                    futureTracker.futuresCompleted().addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Void>>(){

                        public void operationComplete(FutureDone<Void> future) throws Exception {
                            channelCreator.shutdown();
                        }
                    });
                } else {
                    channelCreator.shutdown();
                }
            }
        });
    }
}

