/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.p2p.builder.BootstrapBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerStatistic;
import net.tomp2p.relay.BaseRelayConnection;
import net.tomp2p.relay.DistributedRelay;
import net.tomp2p.relay.FutureRelay;
import net.tomp2p.relay.RelayRPC;
import net.tomp2p.relay.RelayType;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerMapUpdateTask
extends TimerTask {
    private static final Logger LOG = LoggerFactory.getLogger(PeerMapUpdateTask.class);
    private static final long BOOTSTRAP_TIMEOUT_MS = 10000L;
    private final RelayRPC relayRPC;
    private final BootstrapBuilder bootstrapBuilder;
    private final DistributedRelay distributedRelay;
    private Set<PeerAddress> gcmServersLast;

    public PeerMapUpdateTask(RelayRPC relayRPC, BootstrapBuilder bootstrapBuilder, DistributedRelay distributedRelay) {
        this.relayRPC = relayRPC;
        this.bootstrapBuilder = bootstrapBuilder;
        this.distributedRelay = distributedRelay;
        this.gcmServersLast = new HashSet<PeerAddress>(distributedRelay.relayConfig().gcmServers());
    }

    @Override
    public void run() {
        if (this.relayRPC.peer().isShutdown()) {
            this.cancel();
            return;
        }
        this.bootstrapBuilder.start().awaitUninterruptibly(10000L);
        List peerMapVerified = this.relayRPC.peer().peerBean().peerMap().peerMapVerified();
        boolean gcmServersChanged = this.distributedRelay.relayConfig().type() == RelayType.ANDROID && this.gcmServersChanged();
        for (BaseRelayConnection relay : this.distributedRelay.relays()) {
            this.sendPeerMap(relay, peerMapVerified, gcmServersChanged);
        }
        this.gcmServersLast = new HashSet<PeerAddress>(this.distributedRelay.relayConfig().gcmServers());
        FutureRelay futureRelay2 = new FutureRelay();
        this.distributedRelay.setupRelays(futureRelay2);
        this.relayRPC.peer().notifyAutomaticFutures((BaseFuture)futureRelay2);
    }

    private void sendPeerMap(final BaseRelayConnection connection, List<Map<Number160, PeerStatistic>> map, boolean gcmServersChanged) {
        LOG.debug("Sending current routing table to relay {}", (Object)connection.relayAddress());
        Message message = this.relayRPC.createMessage(connection.relayAddress(), RPC.Commands.RELAY.getNr(), Message.Type.REQUEST_3);
        message.neighborsSet(new NeighborSet(-1, RelayUtils.flatten(map)));
        if (gcmServersChanged) {
            LOG.debug("Sending updated GCM server list as well");
            message.neighborsSet(new NeighborSet(-1, this.distributedRelay.relayConfig().gcmServers()));
        }
        FutureResponse fr = connection.sendToRelay(message);
        fr.addListener((BaseFutureListener)new BaseFutureAdapter<BaseFuture>(){

            public void operationComplete(BaseFuture future) throws Exception {
                if (future.isFailed()) {
                    LOG.warn("Failed to update routing table on relay peer {}. Reason: {}", (Object)connection.relayAddress(), (Object)future.failedReason());
                    connection.onMapUpdateFailed();
                } else {
                    LOG.trace("Updated routing table on relay {}", (Object)connection.relayAddress());
                    connection.onMapUpdateSuccess();
                }
            }
        });
    }

    private boolean gcmServersChanged() {
        Collection<PeerAddress> newServers = this.distributedRelay.relayConfig().gcmServers();
        if (newServers == null && this.gcmServersLast == null) {
            return false;
        }
        if (newServers != null && this.gcmServersLast == null || newServers == null && this.gcmServersLast != null) {
            return true;
        }
        return !new HashSet<PeerAddress>(newServers).equals(this.gcmServersLast);
    }
}

