/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.p2p.RequestConfiguration;
import net.tomp2p.p2p.RequestP2PConfiguration;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.p2p.builder.BasicBuilder;
import net.tomp2p.p2p.builder.RoutingBuilder;
import net.tomp2p.p2p.builder.SignatureBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerFilter;

public abstract class DHTBuilder<K extends DHTBuilder<K>>
extends DefaultConnectionConfiguration
implements BasicBuilder<K>,
ConnectionConfiguration,
SignatureBuilder<K> {
    protected final PeerDHT peer;
    protected final Number160 locationKey;
    protected Number160 domainKey;
    protected Number160 versionKey;
    protected RoutingConfiguration routingConfiguration;
    protected RequestP2PConfiguration requestP2PConfiguration;
    protected FutureChannelCreator futureChannelCreator;
    private boolean protectDomain = false;
    private KeyPair keyPair = null;
    private boolean streaming = false;
    private Collection<PeerFilter> peerFilters;
    private K self;

    public DHTBuilder(PeerDHT peer, Number160 locationKey) {
        this.peer = peer;
        this.locationKey = locationKey;
    }

    public void self(K self) {
        this.self = self;
    }

    public Number160 locationKey() {
        return this.locationKey;
    }

    public Number160 domainKey() {
        return this.domainKey;
    }

    public K domainKey(Number160 domainKey) {
        this.domainKey = domainKey;
        return this.self;
    }

    public Number160 versionKey() {
        return this.versionKey;
    }

    public K versionKey(Number160 versionKey) {
        this.versionKey = versionKey;
        return this.self;
    }

    public RoutingConfiguration routingConfiguration() {
        return this.routingConfiguration;
    }

    public K routingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this.self;
    }

    public RequestP2PConfiguration requestP2PConfiguration() {
        return this.requestP2PConfiguration;
    }

    public K requestP2PConfiguration(RequestP2PConfiguration requestP2PConfiguration) {
        this.requestP2PConfiguration = requestP2PConfiguration;
        return this.self;
    }

    public FutureChannelCreator futureChannelCreator() {
        return this.futureChannelCreator;
    }

    public K futureChannelCreator(FutureChannelCreator futureChannelCreator) {
        this.futureChannelCreator = futureChannelCreator;
        return this.self;
    }

    public boolean isProtectDomain() {
        return this.protectDomain;
    }

    public K protectDomain(boolean protectDomain) {
        this.protectDomain = protectDomain;
        return this.self;
    }

    public K protectDomain() {
        this.protectDomain = true;
        if (this.keyPair == null) {
            this.sign();
        }
        return this.self;
    }

    public boolean isSign() {
        return this.keyPair != null;
    }

    public K sign(boolean signMessage) {
        if (signMessage) {
            this.sign();
        } else {
            this.keyPair = null;
        }
        return this.self;
    }

    public K sign() {
        this.keyPair = this.peer.peer().peerBean().keyPair();
        return this.self;
    }

    public K keyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this.self;
    }

    public KeyPair keyPair() {
        return this.keyPair;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public K streaming(boolean streaming) {
        this.streaming = streaming;
        return this.self;
    }

    public K streaming() {
        this.streaming = true;
        return this.self;
    }

    public K addPeerFilter(PeerFilter peerFilter) {
        if (this.peerFilters == null) {
            this.peerFilters = new ArrayList<PeerFilter>(2);
        }
        this.peerFilters.add(peerFilter);
        return this.self;
    }

    public Collection<PeerFilter> peerFilters() {
        return this.peerFilters;
    }

    protected void preBuild(String name) {
        if (this.domainKey == null) {
            this.domainKey = Number160.ZERO;
        }
        if (this.versionKey == null) {
            this.versionKey = Number160.ZERO;
        }
        if (this.routingConfiguration == null) {
            this.routingConfiguration = new RoutingConfiguration(5, 10, 2);
        }
        if (this.requestP2PConfiguration == null) {
            this.requestP2PConfiguration = new RequestP2PConfiguration(3, 5, 3);
        }
        int size = this.peer.peer().peerBean().peerMap().size() + 1;
        this.requestP2PConfiguration = this.requestP2PConfiguration.adjustMinimumResult(size);
        if (this.futureChannelCreator == null || this.futureChannelCreator.channelCreator() != null && this.futureChannelCreator.channelCreator().isShutdown()) {
            this.futureChannelCreator = this.peer.peer().connectionBean().reservation().create(this.routingConfiguration, (RequestConfiguration)this.requestP2PConfiguration, (DefaultConnectionConfiguration)this);
        }
    }

    public RoutingBuilder createBuilder(RequestP2PConfiguration requestP2PConfiguration, RoutingConfiguration routingConfiguration) {
        RoutingBuilder routingBuilder = new RoutingBuilder();
        routingBuilder.parallel(routingConfiguration.parallel());
        routingBuilder.setMaxNoNewInfo(routingConfiguration.maxNoNewInfo(requestP2PConfiguration.minimumResults()));
        routingBuilder.maxDirectHits(routingConfiguration.maxDirectHits());
        routingBuilder.maxFailures(routingConfiguration.maxFailures());
        routingBuilder.maxSuccess(routingConfiguration.maxSuccess());
        return routingBuilder;
    }
}

