/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import java.io.IOException;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import net.tomp2p.dht.DHTBuilder;
import net.tomp2p.dht.FuturePut;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.storage.Data;

public class PutBuilder
extends DHTBuilder<PutBuilder> {
    private static final FuturePut FUTURE_SHUTDOWN = (FuturePut)new FuturePut(null, 0, 0).failed("put builder - peer is shutting down");
    private Map.Entry<Number640, Data> data;
    private Map<Number640, Data> dataMap;
    private Map<Number160, Data> dataMapConvert;
    private boolean putIfAbsent = false;
    private boolean putMeta = false;
    private boolean putConfim = false;
    private PublicKey changePublicKey = null;

    public PutBuilder(PeerDHT peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    public Map.Entry<Number640, Data> data() {
        return this.data;
    }

    public PutBuilder data(Data data) {
        return this.data(this.locationKey, this.domainKey == null ? Number160.ZERO : this.domainKey, Number160.ZERO, this.versionKey == null ? Number160.ZERO : this.versionKey, data);
    }

    public PutBuilder data(Number160 contentKey, Data data) {
        return this.data(this.locationKey, this.domainKey == null ? Number160.ZERO : this.domainKey, contentKey, this.versionKey == null ? Number160.ZERO : this.versionKey, data);
    }

    public PutBuilder data(Number160 domainKey, Number160 contentKey, Data data) {
        return this.data(this.locationKey, domainKey, contentKey, this.versionKey == null ? Number160.ZERO : this.versionKey, data);
    }

    public PutBuilder data(Data data, Number160 versionKey) {
        return this.data(this.locationKey, this.domainKey == null ? Number160.ZERO : this.domainKey, Number160.ZERO, versionKey, data);
    }

    public PutBuilder data(Number160 contentKey, Data data, Number160 versionKey) {
        return this.data(this.locationKey, this.domainKey == null ? Number160.ZERO : this.domainKey, contentKey, versionKey, data);
    }

    public PutBuilder data(final Number160 locationKey, final Number160 domainKey, final Number160 contentKey, final Number160 versionKey, final Data data) {
        this.data = new Map.Entry<Number640, Data>(){

            @Override
            public Data setValue(Data value) {
                return null;
            }

            @Override
            public Data getValue() {
                return data;
            }

            @Override
            public Number640 getKey() {
                return new Number640(locationKey, domainKey, contentKey, versionKey);
            }
        };
        return this;
    }

    @Override
    public PutBuilder domainKey(Number160 domainKey) {
        if (this.data != null) {
            this.data(this.data.getKey().locationKey(), domainKey, this.data.getKey().contentKey(), this.data.getKey().versionKey(), this.data.getValue());
        }
        super.domainKey(domainKey);
        return this;
    }

    @Override
    public PutBuilder versionKey(Number160 versionKey) {
        if (this.data != null) {
            this.data(this.data.getKey().locationKey(), this.data.getKey().domainKey(), this.data.getKey().contentKey(), versionKey, this.data.getValue());
        }
        super.versionKey(versionKey);
        return this;
    }

    public PutBuilder object(Object object) throws IOException {
        return this.data(new Data(object));
    }

    public PutBuilder keyObject(Number160 contentKey, Object object) throws IOException {
        return this.data(contentKey, new Data(object));
    }

    public Map<Number640, Data> dataMap() {
        return this.dataMap;
    }

    public PutBuilder dataMap(Map<Number640, Data> dataMap) {
        this.dataMap = dataMap;
        return this;
    }

    public Map<Number160, Data> dataMapContent() {
        return this.dataMapConvert;
    }

    public PutBuilder dataMapContent(Map<Number160, Data> dataMapConvert) {
        this.dataMapConvert = dataMapConvert;
        return this;
    }

    public boolean isPutIfAbsent() {
        return this.putIfAbsent;
    }

    public PutBuilder putIfAbsent(boolean putIfAbsent) {
        this.putIfAbsent = putIfAbsent;
        return this;
    }

    public PutBuilder putIfAbsent() {
        this.putIfAbsent = true;
        return this;
    }

    public boolean isPutMeta() {
        return this.putMeta;
    }

    public PutBuilder putMeta(boolean putMeta) {
        this.putMeta = putMeta;
        return this;
    }

    public PutBuilder putMeta() {
        this.putMeta = true;
        return this;
    }

    public boolean isPutConfirm() {
        return this.putConfim;
    }

    public PutBuilder putConfirm() {
        this.putConfim = true;
        return this;
    }

    public PutBuilder changePublicKey(PublicKey changePublicKey) {
        this.changePublicKey = changePublicKey;
        this.putMeta = true;
        this.sign();
        return this;
    }

    public PublicKey changePublicKey() {
        return this.changePublicKey;
    }

    public FuturePut start() {
        if (this.peer.peer().isShutdown()) {
            return FUTURE_SHUTDOWN;
        }
        this.preBuild("put-builder");
        if (this.data != null) {
            if (this.dataMap == null) {
                this.dataMap(new HashMap<Number640, Data>(1));
            }
            this.dataMap().put(this.data().getKey(), this.data().getValue());
        }
        if (!this.putMeta && !this.putConfim && this.dataMap == null && this.dataMapConvert == null) {
            throw new IllegalArgumentException("You must either set data via setDataMap() or setData(). Cannot add nothing.");
        }
        if (this.locationKey == null) {
            throw new IllegalArgumentException("You must provide a location key.");
        }
        if (this.domainKey == null) {
            this.domainKey = Number160.ZERO;
        }
        if (this.versionKey == null) {
            this.versionKey = Number160.ZERO;
        }
        return this.peer.distributedHashTable().put(this);
    }
}

