/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.Number640;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.DigestStorage;
import net.tomp2p.storage.KeyLock;
import net.tomp2p.storage.Storage;
import net.tomp2p.utils.Pair;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageLayer
implements DigestStorage {
    private static final Logger LOG = LoggerFactory.getLogger(StorageLayer.class);
    private ProtectionMode protectionDomainMode = ProtectionMode.MASTER_PUBLIC_KEY;
    private ProtectionEnable protectionDomainEnable = ProtectionEnable.ALL;
    private ProtectionMode protectionEntryMode = ProtectionMode.MASTER_PUBLIC_KEY;
    private ProtectionEnable protectionEntryEnable = ProtectionEnable.ALL;
    private final Collection<Number160> removedDomains = new HashSet<Number160>();
    private final KeyLock<Storage> dataLock = new KeyLock();
    private final KeyLock<Number160> dataLock160 = new KeyLock();
    private final KeyLock<Number320> dataLock320 = new KeyLock();
    private final KeyLock<Number480> dataLock480 = new KeyLock();
    private final KeyLock<Number640> dataLock640 = new KeyLock();
    private final KeyLock<Number160> responsibilityLock = new KeyLock();
    private final Storage backend;

    public StorageLayer(Storage backend) {
        this.backend = backend;
    }

    public void protection(ProtectionEnable protectionDomainEnable, ProtectionMode protectionDomainMode, ProtectionEnable protectionEntryEnable, ProtectionMode protectionEntryMode) {
        this.protectionDomainEnable(protectionDomainEnable);
        this.protectionDomainMode(protectionDomainMode);
        this.protectionEntryEnable(protectionEntryEnable);
        this.protectionEntryMode(protectionEntryMode);
    }

    public void protectionDomainMode(ProtectionMode protectionDomainMode) {
        this.protectionDomainMode = protectionDomainMode;
    }

    public ProtectionMode protectionDomainMode() {
        return this.protectionDomainMode;
    }

    public void protectionDomainEnable(ProtectionEnable protectionDomainEnable) {
        this.protectionDomainEnable = protectionDomainEnable;
    }

    public ProtectionEnable protectionDomainEnable() {
        return this.protectionDomainEnable;
    }

    public void protectionEntryMode(ProtectionMode protectionEntryMode) {
        this.protectionEntryMode = protectionEntryMode;
    }

    public ProtectionMode protectionEntryMode() {
        return this.protectionEntryMode;
    }

    public void protectionEntryEnable(ProtectionEnable protectionEntryEnable) {
        this.protectionEntryEnable = protectionEntryEnable;
    }

    public ProtectionEnable protectionEntryEnable() {
        return this.protectionEntryEnable;
    }

    public void removeDomainProtection(Number160 removeDomain) {
        this.removedDomains.add(removeDomain);
    }

    boolean isDomainRemoved(Number160 domain) {
        return this.removedDomains.contains(domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enum<?> put(Number640 key, Data newData, PublicKey publicKey, boolean putIfAbsent, boolean domainProtection) {
        boolean retVal = false;
        KeyLock.RefCounterLock lock = this.dataLock480.lock((Object)key.locationAndDomainAndContentKey());
        try {
            if (!this.securityDomainCheck(key.locationAndDomainKey(), publicKey, publicKey, domainProtection)) {
                PutStatus putStatus = PutStatus.FAILED_SECURITY;
                return putStatus;
            }
            if (!this.securityEntryCheck(key.locationAndDomainAndContentKey(), publicKey, newData.publicKey(), newData.isProtectedEntry())) {
                PutStatus putStatus = PutStatus.FAILED_SECURITY;
                return putStatus;
            }
            boolean contains = this.backend.contains(key);
            if (putIfAbsent && contains) {
                PutStatus putStatus = PutStatus.FAILED_NOT_ABSENT;
                return putStatus;
            }
            NavigableMap tmp = this.backend.subMap(key.minVersionKey(), key.maxVersionKey(), -1, true);
            if (tmp.containsKey(key) && ((Data)tmp.get(key)).isDeleted()) {
                PutStatus putStatus = PutStatus.DELETED;
                return putStatus;
            }
            tmp.put(key, newData);
            boolean versionFork = this.getLatestInternal(tmp).size() > 1;
            retVal = this.backend.put(key, newData);
            if (retVal) {
                long expiration = newData.expirationMillis();
                this.backend.addTimeout(key, expiration);
            }
            if (retVal && versionFork) {
                PutStatus putStatus = PutStatus.VERSION_FORK;
                return putStatus;
            }
            if (retVal) {
                PutStatus putStatus = PutStatus.OK;
                return putStatus;
            }
            PutStatus putStatus = PutStatus.FAILED;
            return putStatus;
        }
        finally {
            this.dataLock480.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Data, Enum<?>> remove(Number640 key, PublicKey publicKey, boolean returnData) {
        KeyLock.RefCounterLock lock = this.dataLock640.lock((Object)key);
        try {
            if (!this.canClaimDomain(key.locationAndDomainKey(), publicKey)) {
                Pair pair = new Pair(null, (Object)PutStatus.FAILED_SECURITY);
                return pair;
            }
            if (!this.canClaimEntry(key.locationAndDomainAndContentKey(), publicKey)) {
                Pair pair = new Pair(null, (Object)PutStatus.FAILED_SECURITY);
                return pair;
            }
            if (!this.backend.contains(key)) {
                Pair pair = new Pair(null, (Object)PutStatus.NOT_FOUND);
                return pair;
            }
            this.backend.removeTimeout(key);
            Pair pair = new Pair((Object)this.backend.remove(key, returnData), (Object)PutStatus.OK);
            return pair;
        }
        finally {
            this.dataLock640.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data get(Number640 key) {
        KeyLock.RefCounterLock lock = this.dataLock640.lock((Object)key);
        try {
            Data data = this.getInternal(key);
            return data;
        }
        finally {
            this.dataLock640.unlock(lock);
        }
    }

    private Data getInternal(Number640 key) {
        Data data = this.backend.get(key);
        if (data != null && !data.hasPrepareFlag()) {
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableMap<Number640, Data> get(Number640 from, Number640 to, int limit, boolean ascending) {
        KeyLock.RefCounterLock lock = this.findAndLock(from, to);
        try {
            NavigableMap tmp = this.backend.subMap(from, to, limit, ascending);
            this.removePrepared(tmp);
            NavigableMap navigableMap = tmp;
            return navigableMap;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Number640, Data> getLatestVersion(Number640 key) {
        KeyLock.RefCounterLock lock = this.dataLock480.lock((Object)key.locationAndDomainAndContentKey());
        try {
            NavigableMap tmp = this.backend.subMap(key.minVersionKey(), key.maxVersionKey(), -1, true);
            this.removePrepared(tmp);
            Map<Number640, Data> map = this.getLatestInternal(tmp);
            return map;
        }
        finally {
            this.dataLock480.unlock(lock);
        }
    }

    private Map<Number640, Data> getLatestInternal(NavigableMap<Number640, Data> tmp) {
        HashMap<Number640, Data> result = new HashMap<Number640, Data>();
        while (!tmp.isEmpty()) {
            Map.Entry<Number640, Data> latest = tmp.lastEntry();
            result.put(latest.getKey(), latest.getValue());
            this.deletePredecessors(latest.getKey(), tmp);
        }
        return result;
    }

    private void removePrepared(NavigableMap<Number640, Data> tmp) {
        Iterator iterator = tmp.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((Data)entry.getValue()).hasPrepareFlag()) continue;
            iterator.remove();
        }
    }

    private void deletePredecessors(Number640 key, NavigableMap<Number640, Data> sortedMap) {
        Data version = (Data)sortedMap.remove(key);
        if (version == null) {
            return;
        }
        if (version.basedOnSet().isEmpty()) {
            return;
        }
        for (Number160 basedOnKey : version.basedOnSet()) {
            this.deletePredecessors(new Number640(key.locationAndDomainAndContentKey(), basedOnKey), sortedMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableMap<Number640, Data> get() {
        KeyLock.RefCounterLock lock = this.dataLock.lock((Object)this.backend);
        try {
            NavigableMap navigableMap = this.backend.map();
            return navigableMap;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Number640 key) {
        KeyLock.RefCounterLock lock = this.dataLock640.lock((Object)key);
        try {
            boolean bl = this.backend.contains(key);
            return bl;
        }
        finally {
            this.dataLock640.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Number640, Data> get(Number640 from, Number640 to, SimpleBloomFilter<Number160> contentBloomFilter, SimpleBloomFilter<Number160> versionBloomFilter, int limit, boolean ascending, boolean isBloomFilterAnd) {
        KeyLock.RefCounterLock lock = this.findAndLock(from, to);
        try {
            NavigableMap tmp = this.backend.subMap(from, to, limit, ascending);
            Iterator iterator = tmp.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (((Data)entry.getValue()).hasPrepareFlag()) {
                    iterator.remove();
                    continue;
                }
                if (isBloomFilterAnd) {
                    if (contentBloomFilter != null && !contentBloomFilter.contains((Object)((Number640)entry.getKey()).contentKey())) {
                        iterator.remove();
                        continue;
                    }
                    if (versionBloomFilter == null || versionBloomFilter.contains((Object)((Data)entry.getValue()).hash())) continue;
                    iterator.remove();
                    continue;
                }
                if (contentBloomFilter != null && contentBloomFilter.contains((Object)((Number640)entry.getKey()).contentKey())) {
                    iterator.remove();
                    continue;
                }
                if (versionBloomFilter == null || !versionBloomFilter.contains((Object)((Data)entry.getValue()).hash())) continue;
                iterator.remove();
            }
            NavigableMap navigableMap = tmp;
            return navigableMap;
        }
        finally {
            lock.unlock();
        }
    }

    private KeyLock.RefCounterLock findAndLock(Number640 from, Number640 to) {
        if (!from.locationKey().equals((Object)to.locationKey())) {
            KeyLock.RefCounterLock lock = this.dataLock.lock((Object)this.backend);
            return lock;
        }
        if (!from.domainKey().equals((Object)to.domainKey())) {
            KeyLock.RefCounterLock lock = this.dataLock160.lock((Object)from.locationKey());
            return lock;
        }
        if (!from.contentKey().equals((Object)to.contentKey())) {
            KeyLock.RefCounterLock lock = this.dataLock320.lock((Object)from.locationAndDomainKey());
            return lock;
        }
        if (!from.versionKey().equals((Object)to.versionKey())) {
            KeyLock.RefCounterLock lock = this.dataLock480.lock((Object)from.locationAndDomainAndContentKey());
            return lock;
        }
        KeyLock.RefCounterLock lock = this.dataLock640.lock((Object)from);
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<Number640, Data> removeReturnData(Number640 from, Number640 to, PublicKey publicKey) {
        KeyLock.RefCounterLock lock = this.findAndLock(from, to);
        try {
            NavigableMap tmp = this.backend.subMap(from, to, -1, true);
            for (Number640 key : tmp.keySet()) {
                if (!this.canClaimDomain(key.locationAndDomainKey(), publicKey)) {
                    SortedMap<Number640, Data> sortedMap = null;
                    return sortedMap;
                }
                if (this.canClaimEntry(key.locationAndDomainAndContentKey(), publicKey)) continue;
                SortedMap<Number640, Data> sortedMap = null;
                return sortedMap;
            }
            NavigableMap result = this.backend.remove(from, to, true);
            for (Map.Entry entry : result.entrySet()) {
                Data data = (Data)entry.getValue();
                if (data.publicKey() != null && !data.publicKey().equals(publicKey)) continue;
                this.backend.removeTimeout((Number640)entry.getKey());
            }
            NavigableMap navigableMap = result;
            return navigableMap;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<Number640, Byte> removeReturnStatus(Number640 from, Number640 to, PublicKey publicKey) {
        KeyLock.RefCounterLock lock = this.findAndLock(from, to);
        try {
            NavigableMap tmp = this.backend.subMap(from, to, -1, true);
            TreeMap<Number640, Byte> result = new TreeMap<Number640, Byte>();
            for (Number640 key : tmp.keySet()) {
                Pair<Data, Enum<?>> pair = this.remove(key, publicKey, false);
                result.put(key, (byte)((Enum)pair.element1()).ordinal());
            }
            TreeMap<Number640, Byte> treeMap = result;
            return treeMap;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTimeout() {
        long time = System.currentTimeMillis();
        Collection toRemove = this.backend.subMapTimeout(time);
        if (toRemove.size() > 0) {
            for (Number640 key : toRemove) {
                KeyLock.RefCounterLock lock = this.dataLock640.lock((Object)key);
                try {
                    this.backend.remove(key, false);
                    this.backend.removeTimeout(key);
                }
                finally {
                    lock.unlock();
                }
                Number160 locationKey = key.locationKey();
                KeyLock.RefCounterLock lock1 = this.dataLock160.lock((Object)locationKey);
                try {
                    if (!this.isEmpty(locationKey)) continue;
                    this.backend.removeResponsibility(locationKey);
                }
                finally {
                    lock1.unlock();
                }
            }
        }
    }

    private boolean isEmpty(Number160 locationKey) {
        Number640 from = new Number640(locationKey, Number160.ZERO, Number160.ZERO, Number160.ZERO);
        Number640 to = new Number640(locationKey, Number160.MAX_VALUE, Number160.MAX_VALUE, Number160.MAX_VALUE);
        NavigableMap tmp = this.backend.subMap(from, to, 1, false);
        return tmp.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigestInfo digest(Number640 from, Number640 to, int limit, boolean ascending) {
        DigestInfo digestInfo = new DigestInfo();
        KeyLock.RefCounterLock lock = this.findAndLock(from, to);
        try {
            NavigableMap tmp = this.backend.subMap(from, to, limit, ascending);
            for (Map.Entry entry : tmp.entrySet()) {
                if (((Data)entry.getValue()).hasPrepareFlag()) continue;
                digestInfo.put((Number640)entry.getKey(), ((Data)entry.getValue()).basedOnSet());
            }
            DigestInfo digestInfo2 = digestInfo;
            return digestInfo2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigestInfo digest(Number320 locationAndDomainKey, SimpleBloomFilter<Number160> keyBloomFilter, SimpleBloomFilter<Number160> contentBloomFilter, int limit, boolean ascending, boolean isBloomFilterAnd) {
        DigestInfo digestInfo = new DigestInfo();
        KeyLock.RefCounterLock lock = this.dataLock320.lock((Object)locationAndDomainKey);
        try {
            Number640 from = new Number640(locationAndDomainKey, Number160.ZERO, Number160.ZERO);
            Number640 to = new Number640(locationAndDomainKey, Number160.MAX_VALUE, Number160.MAX_VALUE);
            NavigableMap tmp = this.backend.subMap(from, to, limit, ascending);
            for (Map.Entry entry : tmp.entrySet()) {
                if (isBloomFilterAnd) {
                    if (keyBloomFilter != null && !keyBloomFilter.contains((Object)((Number640)entry.getKey()).contentKey()) || contentBloomFilter != null && !contentBloomFilter.contains((Object)((Data)entry.getValue()).hash()) || ((Data)entry.getValue()).hasPrepareFlag()) continue;
                    digestInfo.put((Number640)entry.getKey(), ((Data)entry.getValue()).basedOnSet());
                    continue;
                }
                if (keyBloomFilter != null && keyBloomFilter.contains((Object)((Number640)entry.getKey()).contentKey()) || contentBloomFilter != null && contentBloomFilter.contains((Object)((Data)entry.getValue()).hash()) || ((Data)entry.getValue()).hasPrepareFlag()) continue;
                digestInfo.put((Number640)entry.getKey(), ((Data)entry.getValue()).basedOnSet());
            }
            DigestInfo digestInfo2 = digestInfo;
            return digestInfo2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigestInfo digest(Collection<Number640> number640s) {
        DigestInfo digestInfo = new DigestInfo();
        for (Number640 number640 : number640s) {
            KeyLock.RefCounterLock lock = this.dataLock640.lock((Object)number640);
            try {
                Data data;
                if (!this.backend.contains(number640) || (data = this.getInternal(number640)) == null) continue;
                digestInfo.put(number640, data.basedOnSet());
            }
            finally {
                lock.unlock();
            }
        }
        return digestInfo;
    }

    private boolean securityDomainCheck(Number320 key, PublicKey publicKey, PublicKey newPublicKey, boolean domainProtection) {
        boolean domainProtectedByOthers = this.backend.isDomainProtectedByOthers(key, publicKey);
        if (!domainProtection) {
            LOG.debug("no domain protection requested {} for domain {}", (Object)Utils.hash((PublicKey)newPublicKey), (Object)key);
            return !domainProtectedByOthers;
        }
        LOG.debug("domain protection requested {} for domain {}", (Object)Utils.hash((PublicKey)newPublicKey), (Object)key);
        if (this.canClaimDomain(key, publicKey)) {
            if (this.canProtectDomain(key.domainKey(), publicKey)) {
                LOG.debug("set domain protection");
                return this.backend.protectDomain(key, newPublicKey);
            }
            return true;
        }
        return false;
    }

    private boolean securityEntryCheck(Number480 key, PublicKey publicKeyMessage, PublicKey publicKeyData, boolean entryProtection) {
        boolean entryProtectedByOthers = this.backend.isEntryProtectedByOthers(key, publicKeyMessage);
        if (!entryProtection) {
            return !entryProtectedByOthers;
        }
        if (this.canClaimEntry(key, publicKeyMessage)) {
            if (this.canProtectEntry(key.domainKey(), publicKeyMessage)) {
                return this.backend.protectEntry(key, publicKeyData);
            }
            return true;
        }
        return false;
    }

    private boolean foreceOverrideDomain(Number160 domainKey, PublicKey publicKey) {
        if (this.protectionDomainMode() == ProtectionMode.MASTER_PUBLIC_KEY && publicKey != null) {
            return StorageLayer.isMine(domainKey, publicKey);
        }
        return false;
    }

    private boolean foreceOverrideEntry(Number160 entryKey, PublicKey publicKey) {
        if (this.protectionEntryMode() == ProtectionMode.MASTER_PUBLIC_KEY && publicKey != null && publicKey.getEncoded() != null) {
            return StorageLayer.isMine(entryKey, publicKey);
        }
        return false;
    }

    private boolean canClaimDomain(Number320 key, PublicKey publicKey) {
        boolean domainProtectedByOthers = this.backend.isDomainProtectedByOthers(key, publicKey);
        boolean domainOverridableByMe = this.foreceOverrideDomain(key.domainKey(), publicKey);
        return !domainProtectedByOthers || domainOverridableByMe;
    }

    private boolean canClaimEntry(Number480 key, PublicKey publicKey) {
        boolean entryProtectedByOthers = this.backend.isEntryProtectedByOthers(key, publicKey);
        boolean entryOverridableByMe = this.foreceOverrideEntry(key.contentKey(), publicKey);
        return !entryProtectedByOthers || entryOverridableByMe;
    }

    private boolean canProtectDomain(Number160 domainKey, PublicKey publicKey) {
        if (this.isDomainRemoved(domainKey)) {
            return false;
        }
        if (this.protectionDomainEnable() == ProtectionEnable.ALL) {
            return true;
        }
        if (this.protectionDomainEnable() == ProtectionEnable.NONE) {
            return this.foreceOverrideDomain(domainKey, publicKey);
        }
        return false;
    }

    private boolean canProtectEntry(Number160 contentKey, PublicKey publicKey) {
        if (this.protectionEntryEnable() == ProtectionEnable.ALL) {
            return true;
        }
        if (this.protectionEntryEnable() == ProtectionEnable.NONE) {
            return this.foreceOverrideEntry(contentKey, publicKey);
        }
        return false;
    }

    private static boolean isMine(Number160 key, PublicKey publicKey) {
        return key.equals((Object)Utils.makeSHAHash((byte[])publicKey.getEncoded()));
    }

    public KeyLock<Storage> lockStorage() {
        return this.dataLock;
    }

    public KeyLock<Number160> lockNumber160() {
        return this.dataLock160;
    }

    public KeyLock<Number320> lockNumber320() {
        return this.dataLock320;
    }

    public KeyLock<Number480> lockNumber480() {
        return this.dataLock480;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Number160> findContentForResponsiblePeerID(Number160 peerID) {
        Collection contentIDs = this.backend.findContentForResponsiblePeerID(peerID);
        if (contentIDs == null) {
            return Collections.emptyList();
        }
        KeyLock.RefCounterLock lock = this.responsibilityLock.lock((Object)peerID);
        try {
            ArrayList<Number160> arrayList = new ArrayList<Number160>(contentIDs);
            return arrayList;
        }
        finally {
            this.responsibilityLock.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Number160> findPeerIDsForResponsibleContent(Number160 locationKey) {
        Collection peerIDs = this.backend.findPeerIDsForResponsibleContent(locationKey);
        if (peerIDs == null) {
            return Collections.emptyList();
        }
        KeyLock.RefCounterLock lock = this.responsibilityLock.lock((Object)locationKey);
        try {
            ArrayList<Number160> arrayList = new ArrayList<Number160>(peerIDs);
            return arrayList;
        }
        finally {
            this.responsibilityLock.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateResponsibilities(Number160 locationKey, Number160 peerId) {
        KeyLock.RefCounterLock lock1 = this.responsibilityLock.lock((Object)peerId);
        KeyLock.RefCounterLock lock2 = this.responsibilityLock.lock((Object)locationKey);
        try {
            boolean bl = this.backend.updateResponsibilities(locationKey, peerId);
            return bl;
        }
        finally {
            this.responsibilityLock.unlock(lock1);
            this.responsibilityLock.unlock(lock2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResponsibility(Number160 locationKey, boolean keepData) {
        KeyLock.RefCounterLock lock = this.responsibilityLock.lock((Object)locationKey);
        try {
            if (!keepData) {
                this.backend.remove(new Number640(locationKey, Number160.ZERO, Number160.ZERO, Number160.ZERO), new Number640(locationKey, Number160.MAX_VALUE, Number160.MAX_VALUE, Number160.MAX_VALUE), false);
            }
            this.backend.removeResponsibility(locationKey);
        }
        finally {
            this.responsibilityLock.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResponsibility(Number160 locationKey, Number160 peerId) {
        KeyLock.RefCounterLock lock1 = this.responsibilityLock.lock((Object)peerId);
        KeyLock.RefCounterLock lock2 = this.responsibilityLock.lock((Object)locationKey);
        try {
            this.backend.removeResponsibility(locationKey, peerId);
        }
        finally {
            this.responsibilityLock.unlock(lock1);
            this.responsibilityLock.unlock(lock2);
        }
    }

    public void start(ScheduledExecutorService timer, int storageIntervalMillis) {
        timer.scheduleAtFixedRate(new StorageMaintenanceTask(), storageIntervalMillis, storageIntervalMillis, TimeUnit.MILLISECONDS);
    }

    public Enum<?> updateMeta(Number320 locationAndDomainKey, PublicKey publicKey, PublicKey newPublicKey) {
        if (!this.securityDomainCheck(locationAndDomainKey, publicKey, newPublicKey, true)) {
            return PutStatus.FAILED_SECURITY;
        }
        return PutStatus.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enum<?> updateMeta(PublicKey publicKey, Number640 key, Data newData) {
        boolean found = false;
        KeyLock.RefCounterLock lock = this.dataLock640.lock((Object)key);
        try {
            if (!this.securityEntryCheck(key.locationAndDomainAndContentKey(), publicKey, newData.publicKey(), newData.isProtectedEntry())) {
                PutStatus putStatus = PutStatus.FAILED_SECURITY;
                return putStatus;
            }
            Data data = this.backend.get(key);
            boolean changed = false;
            if (data != null && newData.publicKey() != null) {
                data.publicKey(newData.publicKey());
                changed = true;
            }
            if (data != null && newData.isSigned()) {
                data.signature(newData.signature());
                changed = true;
            }
            if (data != null) {
                data.validFromMillis(newData.validFromMillis());
                data.ttlSeconds(newData.ttlSeconds());
                changed = true;
            }
            if (changed) {
                long expiration = data.expirationMillis();
                this.backend.addTimeout(key, expiration);
                found = this.backend.put(key, data);
            }
        }
        finally {
            this.dataLock640.unlock(lock);
        }
        return found ? PutStatus.OK : PutStatus.NOT_FOUND;
    }

    public int storageCheckIntervalMillis() {
        return this.backend.storageCheckIntervalMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enum<?> putConfirm(PublicKey publicKey, Number640 key, Data newData) {
        boolean found = false;
        KeyLock.RefCounterLock lock = this.dataLock640.lock((Object)key);
        try {
            if (!this.securityEntryCheck(key.locationAndDomainAndContentKey(), publicKey, newData.publicKey(), newData.isProtectedEntry())) {
                PutStatus putStatus = PutStatus.FAILED_SECURITY;
                return putStatus;
            }
            Data data = this.backend.get(key);
            if (data != null) {
                data.prepareFlag(false);
                data.validFromMillis(newData.validFromMillis());
                data.ttlSeconds(newData.ttlSeconds());
                long expiration = data.expirationMillis();
                this.backend.addTimeout(key, expiration);
                found = this.backend.put(key, data);
            }
        }
        finally {
            this.dataLock640.unlock(lock);
        }
        return found ? PutStatus.OK : PutStatus.NOT_FOUND;
    }

    private class StorageMaintenanceTask
    implements Runnable {
        private StorageMaintenanceTask() {
        }

        @Override
        public void run() {
            StorageLayer.this.checkTimeout();
        }
    }

    public static enum PutStatus {
        OK,
        FAILED_NOT_ABSENT,
        FAILED_SECURITY,
        FAILED,
        VERSION_FORK,
        NOT_FOUND,
        DELETED;

    }

    public static enum ProtectionMode {
        NO_MASTER,
        MASTER_PUBLIC_KEY;

    }

    public static enum ProtectionEnable {
        ALL,
        NONE;

    }
}

