/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import net.tomp2p.examples.ExampleUtils;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.p2p.AutomaticFuture;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.Shutdown;
import net.tomp2p.p2p.builder.Builder;
import net.tomp2p.p2p.builder.PutBuilder;
import net.tomp2p.p2p.builder.RemoveBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.replication.DirectReplication;
import net.tomp2p.storage.Data;
import net.tomp2p.utils.Timings;

public final class ExampleDirectReplication {
    private static final int NINE_SECONDS = 9000;

    private ExampleDirectReplication() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Peer[] peers = null;
        try {
            int nrPeers = 100;
            int port = 4001;
            peers = ExampleUtils.createAndAttachNodes(100, 4001);
            ExampleUtils.bootstrap(peers);
            ExampleDirectReplication.exmpleDirectReplication(peers);
        }
        finally {
            if (peers != null && peers[0] != null) {
                peers[0].shutdown();
            }
        }
    }

    private static void exmpleDirectReplication(Peer[] peers) throws IOException {
        PutBuilder putBuilder = peers[1].put(Number160.ONE).setData(new Data((Object)"test"));
        DirectReplication replication = new DirectReplication(peers[1]);
        Shutdown shutdown = replication.direct((Builder)putBuilder, 1000, -1, new AutomaticFuture(){

            public void futureCreated(BaseFuture future) {
                System.out.println("put again...");
            }
        });
        Timings.sleepUninterruptibly((int)9000);
        System.out.println("stop replication");
        shutdown.shutdown();
        RemoveBuilder removeBuilder = peers[1].remove(Number160.ONE);
        replication.direct((Builder)removeBuilder, 1000, 9, new AutomaticFuture(){

            public void futureCreated(BaseFuture future) {
                System.out.println("remove again...");
            }
        });
        Timings.sleepUninterruptibly((int)9000);
        System.out.println("done");
        replication.shutdown().awaitUninterruptibly();
    }
}

