/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import net.tomp2p.examples.ExampleUtils;
import net.tomp2p.futures.FutureGet;
import net.tomp2p.futures.FuturePut;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.GetBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.Data;

public class ExampleHashMap {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Peer master = null;
        try {
            Peer[] peers = ExampleUtils.createAndAttachNodes(100, 4001);
            master = peers[0];
            MyPeer myPeer1 = new MyPeer(peers[0]);
            ExampleUtils.bootstrap(peers);
            myPeer1.put("This is my location key", "This is my domain", "This is my content key", "And here comes the data").awaitUninterruptibly();
            MyPeer myPeer2 = new MyPeer(peers[5]);
            FutureGet futureGet = myPeer2.get("This is my location key", "This is my domain", "This is my content key");
            futureGet.awaitUninterruptibly();
            Map map = futureGet.getDataMap();
            for (Data data : map.values()) {
                MyData myData = (MyData)data.object();
                System.out.println("key: " + (String)myData.key() + ", domain: " + myData.domain() + ", content: " + (String)myData.content() + ", data: " + (String)myData.data());
            }
        }
        finally {
            master.shutdown();
        }
    }

    private static class MyData<K>
    implements Serializable {
        private static final long serialVersionUID = 2098774660703812030L;
        private K key;
        private K domain;
        private K content;
        private K data;

        private MyData() {
        }

        public K key() {
            return this.key;
        }

        public MyData<K> key(K key) {
            this.key = key;
            return this;
        }

        public Object domain() {
            return this.domain;
        }

        public MyData<K> domain(K domain) {
            this.domain = domain;
            return this;
        }

        public K content() {
            return this.content;
        }

        public MyData<K> content(K content) {
            this.content = content;
            return this;
        }

        public K data() {
            return this.data;
        }

        public MyData<K> data(K data) {
            this.data = data;
            return this;
        }
    }

    private static class MyPeer {
        private final Peer peer;

        private MyPeer(Peer peer) {
            this.peer = peer;
        }

        private FutureGet get(String key, String domain, String content) {
            Number160 locationKey = Number160.createHash((String)key);
            Number160 domainKey = Number160.createHash((String)domain);
            Number160 contentKey = Number160.createHash((String)content);
            return ((GetBuilder)this.peer.get(locationKey).setDomainKey(domainKey)).setContentKey(contentKey).start();
        }

        private FuturePut put(String key, String domain, String content, String data) throws IOException {
            Number160 locationKey = Number160.createHash((String)key);
            Number160 domainKey = Number160.createHash((String)domain);
            Number160 contentKey = Number160.createHash((String)content);
            MyData<String> myData = new MyData<String>().key(key).domain(domain).content(content).data(data);
            return this.peer.put(locationKey).setDomainKey(domainKey).setData(contentKey, new Data(myData)).start();
        }
    }
}

