/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import net.tomp2p.futures.FutureDigest;
import net.tomp2p.futures.FuturePut;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerMaker;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.Data;

public final class ExampleIndirectReplication {
    private static final int ONE_SECOND = 1000;

    private ExampleIndirectReplication() {
    }

    public static void main(String[] args) throws Exception {
        ExampleIndirectReplication.exmpleIndirectReplication();
    }

    private static void exmpleIndirectReplication() throws IOException, InterruptedException {
        int port1 = 4001;
        boolean nr1 = true;
        int port2 = 4002;
        int nr2 = 2;
        int port3 = 4003;
        int nr3 = 4;
        Peer peer1 = new PeerMaker(new Number160(1)).ports(4001).setEnableIndirectReplication(true).makeAndListen();
        Peer peer2 = new PeerMaker(new Number160(2)).ports(4002).setEnableIndirectReplication(true).makeAndListen();
        Peer peer3 = new PeerMaker(new Number160(4)).ports(4003).setEnableIndirectReplication(true).makeAndListen();
        Peer[] peers = new Peer[]{peer1, peer2, peer3};
        FuturePut futurePut = peer1.put(new Number160(4)).setData(new Data((Object)"store on peer1")).start();
        futurePut.awaitUninterruptibly();
        FutureDigest futureDigest = peer1.digest(new Number160(4)).start();
        futureDigest.awaitUninterruptibly();
        System.out.println("we found the data on " + futureDigest.getRawDigest().size() + " peers");
        peer1.bootstrap().setPeerAddress(peer2.getPeerAddress()).start();
        peer1.bootstrap().setPeerAddress(peer3.getPeerAddress()).start();
        Thread.sleep(1000L);
        futureDigest = peer1.digest(new Number160(4)).start();
        futureDigest.awaitUninterruptibly();
        System.out.println("we found the data on " + futureDigest.getRawDigest().size() + " peers");
        ExampleIndirectReplication.shutdown(peers);
    }

    private static void shutdown(Peer[] peers) {
        for (Peer peer : peers) {
            peer.shutdown();
        }
    }
}

