/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Random;
import net.tomp2p.connection.Bindings;
import net.tomp2p.futures.FutureGet;
import net.tomp2p.futures.FuturePut;
import net.tomp2p.nat.FutureRelayNAT;
import net.tomp2p.nat.PeerNAT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerMaker;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.Data;

public class ExampleRelay {
    private static final Random rnd = new Random();
    private static final int PORT = 7777;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            Bindings b = new Bindings();
            Peer peer = new PeerMaker(Number160.createHash((String)"boot")).setEnableMaintenance(false).ports(7777).bindings(b).makeAndListen();
            System.err.println("bootstrap peer id: " + peer.getPeerAddress().getPeerId());
            new PeerNAT(peer);
            System.err.println("bootstrap peer is running");
            while (true) {
                Thread.sleep(10000L);
                System.err.println(peer.getPeerBean().peerMap().peerMapVerified());
            }
        }
        if (args.length == 3) {
            int port = rnd.nextInt() % 10000 + 10000;
            Peer peer = new PeerMaker(Number160.createHash((String)args[1])).ports(port).setEnableMaintenance(false).makeAndListen();
            System.err.println("put peer id: " + peer.getPeerAddress().getPeerId());
            PeerNAT pnat = new PeerNAT(peer);
            InetAddress address = Inet4Address.getByName(args[0]);
            FutureRelayNAT fbn = pnat.bootstrapBuilder(peer.bootstrap().setInetAddress(address).setPorts(7777)).startRelay();
            fbn.awaitUninterruptibly();
            if (fbn.isSuccess()) {
                System.err.println("Successfuly set up relays");
                Thread.sleep(1000L);
            }
            FuturePut fp = peer.put(Number160.createHash((String)args[1])).setData(new Data((Object)args[2].toUpperCase())).start();
            System.err.println("hash:" + Number160.createHash((String)args[1]));
            fp.awaitUninterruptibly();
            if (fp.isSuccess()) {
                System.err.println("Successfully stored " + args[1] + ":" + args[2]);
            }
        } else if (args.length == 2) {
            int port = rnd.nextInt() % 10000 + 10000;
            Peer peer = new PeerMaker(Number160.createHash((String)"bla")).setEnableMaintenance(false).ports(port).makeAndListen();
            System.err.println("get peer id: " + peer.getPeerAddress().getPeerId());
            System.err.println("hash:" + Number160.createHash((String)args[1]));
            PeerNAT pnat = new PeerNAT(peer);
            InetAddress address = Inet4Address.getByName(args[0]);
            FutureRelayNAT fbn = pnat.bootstrapBuilder(peer.bootstrap().setInetAddress(address).setPorts(7777)).startRelay();
            fbn.awaitUninterruptibly();
            if (fbn.isSuccess()) {
                System.err.println("Successfuly set up relays");
            }
            FutureGet fg = peer.get(Number160.createHash((String)args[1])).start();
            fg.awaitUninterruptibly();
            if (fg.isSuccess()) {
                System.err.println("Received: " + fg.getData().object());
            } else {
                System.err.println(fg.getFailedReason());
            }
        }
    }
}

