/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import net.tomp2p.examples.ExampleUtils;
import net.tomp2p.futures.FutureGet;
import net.tomp2p.futures.FuturePut;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;

public final class ExampleSearch {
    private static final String TERM = "Communication Systems Group";

    private ExampleSearch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int peerNr = 100;
        int port = 4001;
        Peer[] peers = null;
        try {
            peers = ExampleUtils.createAndAttachNodes(100, 4001);
            ExampleUtils.bootstrap(peers);
            ExampleSearch.exampleSearch(peers);
            ExampleSearch.exampleKeywordSearch(peers);
        }
        finally {
            if (peers != null && peers[0] != null) {
                peers[0].shutdown();
            }
        }
    }

    private static void exampleSearch(Peer[] peers) throws IOException, ClassNotFoundException {
        int peer30 = 30;
        int peer60 = 60;
        Number160 key = Number160.createHash((String)TERM);
        FuturePut futurePut = peers[60].put(key).setObject((Object)TERM).start();
        futurePut.awaitUninterruptibly();
        FutureGet futureGet = peers[30].get(key).start();
        futureGet.awaitUninterruptibly();
        System.out.println("got: " + key + " = " + futureGet.getData().object());
    }

    private static void exampleKeywordSearch(Peer[] peers) throws IOException, ClassNotFoundException {
        String[] keywords;
        int peer10 = 10;
        int peer20 = 20;
        Number160 keyTerm = Number160.createHash((String)TERM);
        for (String keyword : keywords = TERM.split(" ")) {
            Number160 keyKeyword = Number160.createHash((String)keyword);
            peers[10].put(keyKeyword).setObject((Object)keyTerm).start().awaitUninterruptibly();
        }
        Number160 termKey = ExampleSearch.findReference(peers[20], "Communication");
        FutureGet futureGet = peers[10].get(termKey).start();
        futureGet.awaitUninterruptibly();
        System.out.println("searched for [Communication], found " + futureGet.getData().object());
    }

    private static Number160 findReference(Peer peer, String keyword) throws ClassNotFoundException, IOException {
        Number160 keyKeyword = Number160.createHash((String)keyword);
        FutureGet futureGet = peer.get(keyKeyword).start();
        futureGet.awaitUninterruptibly();
        Number160 termKey = (Number160)futureGet.getData().object();
        return termKey;
    }
}

