/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

class Query {
    private final QueryType queryType;
    private final String query;
    private final String collectionName;
    private final String value;
    private final List<String> values;
    private final Map<String, String> valueMap;
    private final StringBuilder tmpQuery = new StringBuilder();

    Query(String query) {
        this.query = query.trim();
        this.queryType = this.parseType();
        this.collectionName = this.parseCollectionName();
        Object json = this.parseJSON();
        this.value = this.setSingleValue(json);
        this.values = this.setValues(json);
        this.valueMap = this.setValueMap(json);
    }

    private QueryType parseType() {
        this.tmpQuery.append(this.query);
        if (this.query.toUpperCase().startsWith("INSERT INTO")) {
            this.tmpQuery.delete(0, 11);
            return QueryType.INSERT;
        }
        if (this.query.toUpperCase().startsWith("SELECT FROM")) {
            this.tmpQuery.delete(0, 11);
            return QueryType.SELECT;
        }
        throw new IllegalArgumentException("only insert and select supported");
    }

    private String parseCollectionName() {
        String query = this.tmpQuery.toString().trim();
        int spacePos = query.indexOf(" ");
        if (spacePos > 0) {
            this.tmpQuery.delete(0, spacePos + 1);
            return query.substring(0, spacePos);
        }
        if (query.endsWith(";")) {
            this.tmpQuery.deleteCharAt(this.tmpQuery.length() - 1);
        }
        query = this.tmpQuery.toString().trim();
        return query;
    }

    private Object parseJSON() {
        String query = this.tmpQuery.toString().trim();
        if (query.toUpperCase().startsWith("VALUE")) {
            this.tmpQuery.delete(0, 6);
        }
        if (query.endsWith(";")) {
            this.tmpQuery.deleteCharAt(this.tmpQuery.length() - 1);
        }
        query = this.tmpQuery.toString().trim();
        return JSONValue.parse((String)query);
    }

    private String setSingleValue(Object json) {
        if (json instanceof Long) {
            return Long.toString((Long)json);
        }
        if (json instanceof Double) {
            return Double.toString((Double)json);
        }
        if (json instanceof String) {
            return (String)json;
        }
        return null;
    }

    private List<String> setValues(Object json) {
        if (json instanceof JSONArray) {
            ArrayList<String> retVal = new ArrayList<String>();
            JSONArray array = (JSONArray)json;
            for (Object obj : array) {
                retVal.add(this.setSingleValue(obj));
            }
            return retVal;
        }
        return null;
    }

    private Map<String, String> setValueMap(Object json) {
        if (json instanceof JSONObject) {
            HashMap<String, String> retVal = new HashMap<String, String>();
            JSONObject map = (JSONObject)json;
            for (Object key : map.keySet()) {
                Object value = map.get(key);
                retVal.put(this.setSingleValue(key), this.setSingleValue(value));
            }
            return retVal;
        }
        return null;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public ValueType getValueType() {
        if (this.getValue() != null) {
            return ValueType.SINGLE;
        }
        if (this.getValues() != null) {
            return ValueType.ARRAY;
        }
        return ValueType.MAP;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getValue() {
        return this.value;
    }

    public List<String> getValues() {
        return this.values;
    }

    public Map<String, String> getValueMap() {
        return this.valueMap;
    }

    static enum ValueType {
        SINGLE,
        ARRAY,
        MAP;

    }

    static enum QueryType {
        INSERT,
        SELECT;

    }
}

