/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import net.tomp2p.dht.FutureGet;
import net.tomp2p.dht.FuturePut;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.examples.ExampleUtils;
import net.tomp2p.peers.Number160;

public final class ExampleSearch {
    private static final String TERM = "Communication Systems Group";

    private ExampleSearch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int peerNr = 100;
        int port = 4001;
        PeerDHT[] peers = null;
        try {
            peers = ExampleUtils.createAndAttachPeersDHT(100, 4001);
            ExampleUtils.bootstrap(peers);
            ExampleSearch.exampleSearch(peers);
            ExampleSearch.exampleKeywordSearch(peers);
        }
        finally {
            if (peers != null && peers[0] != null) {
                peers[0].shutdown();
            }
        }
    }

    private static void exampleSearch(PeerDHT[] peers) throws IOException, ClassNotFoundException {
        int peer30 = 30;
        int peer60 = 60;
        Number160 key = Number160.createHash((String)TERM);
        FuturePut futurePut = peers[60].put(key).object((Object)TERM).start();
        futurePut.awaitUninterruptibly();
        FutureGet futureGet = peers[30].get(key).start();
        futureGet.awaitUninterruptibly();
        System.out.println("got: " + key + " = " + futureGet.data().object());
    }

    private static void exampleKeywordSearch(PeerDHT[] peers) throws IOException, ClassNotFoundException {
        String[] keywords;
        int peer10 = 10;
        int peer20 = 20;
        Number160 keyTerm = Number160.createHash((String)TERM);
        for (String keyword : keywords = TERM.split(" ")) {
            Number160 keyKeyword = Number160.createHash((String)keyword);
            peers[10].put(keyKeyword).object((Object)keyTerm).start().awaitUninterruptibly();
        }
        Number160 termKey = ExampleSearch.findReference(peers[20], "Communication");
        FutureGet futureGet = peers[10].get(termKey).start();
        futureGet.awaitUninterruptibly();
        System.out.println("searched for [Communication], found " + futureGet.data().object());
    }

    private static Number160 findReference(PeerDHT peer, String keyword) throws ClassNotFoundException, IOException {
        Number160 keyKeyword = Number160.createHash((String)keyword);
        FutureGet futureGet = peer.get(keyKeyword).start();
        futureGet.awaitUninterruptibly();
        Number160 termKey = (Number160)futureGet.data().object();
        return termKey;
    }
}

