/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.replication;

import java.util.ArrayList;
import java.util.Arrays;
import net.tomp2p.peers.Number160;
import net.tomp2p.replication.Checksum;
import net.tomp2p.replication.Instruction;
import net.tomp2p.utils.Utils;

public final class Synchronization {
    public static final int SIZE = 5;

    static int getAdler(byte[] buffer, int start, int end) {
        return Synchronization.getAdlerInternal(buffer, start, end)[2];
    }

    private static int[] getAdlerInternal(byte[] buffer, int start, int end) {
        int len = end - start + 1;
        int a = 0;
        int b = 0;
        for (int i = 0; i < len; ++i) {
            a += buffer[start + i];
            b += (len - i) * buffer[start + i];
        }
        int[] retval = new int[]{a %= 65536, b %= 65536, a + 65536 * b};
        return retval;
    }

    public static ArrayList<Checksum> getChecksums(byte[] value, int blockSize) {
        int numberOfBlocks = (value.length + blockSize - 1) / blockSize;
        ArrayList<Checksum> checksums = new ArrayList<Checksum>(numberOfBlocks);
        for (int i = 0; i < numberOfBlocks; ++i) {
            int remaining = blockSize;
            if (i == numberOfBlocks - 1 && value.length % blockSize != 0) {
                remaining = value.length % blockSize;
            }
            Checksum checksum = new Checksum();
            checksum.setWeakChecksum(Synchronization.getAdler(value, i * blockSize, i * blockSize + remaining - 1));
            checksum.setStrongChecksum(Utils.makeMD5Hash((byte[])value, (int)(i * blockSize), (int)remaining));
            checksums.add(checksum);
        }
        return checksums;
    }

    static Instruction matches(int wcs, byte[] buffer, int offset, int length, ArrayList<Checksum> checksums) {
        int checksumSize = checksums.size();
        for (int i = 0; i < checksumSize; ++i) {
            int weakChecksum = checksums.get(i).getWeakChecksum();
            if (weakChecksum != wcs) continue;
            byte[] md5 = Utils.makeMD5Hash((byte[])buffer, (int)offset, (int)length);
            byte[] strongChecksum = checksums.get(i).getStrongChecksum();
            if (!Arrays.equals(strongChecksum, md5)) continue;
            Instruction instruction = new Instruction();
            instruction.setReference(i);
            return instruction;
        }
        return null;
    }

    static Instruction getDiff(byte[] newValue, int start, int end) {
        int len = end - start + 1;
        byte[] literal = new byte[len];
        System.arraycopy(newValue, start, literal, 0, len);
        Instruction instruction = new Instruction();
        instruction.setLiteral(literal);
        return instruction;
    }

    private static int[] jump(int offset, int blockSize, byte[] newValue) {
        if (offset + blockSize >= newValue.length) {
            return Synchronization.getAdlerInternal(newValue, offset - 1, newValue.length - 1);
        }
        return Synchronization.getAdlerInternal(newValue, offset - 1, offset + blockSize - 2);
    }

    public static ArrayList<Instruction> getInstructions(byte[] newValue, ArrayList<Checksum> checksums, int blockSize) {
        ArrayList<Instruction> result = new ArrayList<Instruction>();
        int[] adler = Synchronization.getAdlerInternal(newValue, 0, blockSize - 1);
        int a = adler[0];
        int b = adler[1];
        int wcs = adler[2];
        int offset = 0;
        int diff = 0;
        Instruction instruction = Synchronization.matches(wcs, newValue, offset, blockSize, checksums);
        if (instruction != null) {
            result.add(instruction);
            offset = blockSize;
            diff = blockSize;
            int[] jumpVal = Synchronization.jump(offset, blockSize, newValue);
            a = jumpVal[0];
            b = jumpVal[1];
        } else {
            offset = 1;
        }
        result = Synchronization.getInstructions(result, diff, offset, a, b, newValue, checksums, blockSize);
        return result;
    }

    public static ArrayList<Instruction> getInstructions(ArrayList<Instruction> result, int diff, int offset, int a, int b, byte[] newValue, ArrayList<Checksum> checksums, int blockSize) {
        if (offset + blockSize >= newValue.length) {
            int wcs = Synchronization.getAdlerInternal(newValue, offset, newValue.length - 1)[2];
            Instruction instruction1 = Synchronization.matches(wcs, newValue, offset, newValue.length - offset, checksums);
            if (instruction1 != null) {
                if (diff < offset) {
                    result.add(Synchronization.getDiff(newValue, diff, offset - 1));
                }
                result.add(instruction1);
            } else {
                if (++offset >= newValue.length) {
                    if (diff < offset) {
                        result.add(Synchronization.getDiff(newValue, diff, newValue.length - 1));
                    }
                    return result;
                }
                Synchronization.getInstructions(result, diff, offset, a, b, newValue, checksums, blockSize);
            }
            return result;
        }
        int wcs = (a = (a - newValue[offset - 1] + newValue[offset + blockSize - 1]) % 65536) + 65536 * (b = (b - blockSize * newValue[offset - 1] + a) % 65536);
        Instruction instruction1 = Synchronization.matches(wcs, newValue, offset, blockSize, checksums);
        if (instruction1 != null) {
            if (diff < offset) {
                result.add(Synchronization.getDiff(newValue, diff, offset - 1));
            }
            result.add(instruction1);
            diff = offset + blockSize;
            a = Synchronization.jump(offset += blockSize, blockSize, newValue)[0];
            b = Synchronization.jump(offset, blockSize, newValue)[1];
            Synchronization.getInstructions(result, diff, offset, a, b, newValue, checksums, blockSize);
        } else {
            Synchronization.getInstructions(result, diff, ++offset, a, b, newValue, checksums, blockSize);
        }
        return result;
    }

    public static byte[] getReconstructedValue(byte[] oldValue, ArrayList<Instruction> instructions, int blockSize) {
        int numberOfBlocks = (oldValue.length + blockSize - 1) / blockSize;
        int lastBlockSize = oldValue.length % blockSize == 0 ? blockSize : oldValue.length % blockSize;
        int newSize = 0;
        for (Instruction instruction : instructions) {
            if (instruction.getReference() == -1) {
                newSize += instruction.getLiteral().length;
                continue;
            }
            newSize += instruction.getReference() == numberOfBlocks - 1 ? lastBlockSize : blockSize;
        }
        byte[] reconstructedValue = new byte[newSize];
        int offset = 0;
        for (Instruction instruction : instructions) {
            int len;
            if (instruction.getReference() == -1) {
                len = instruction.getLiteral().length;
                System.arraycopy(instruction.getLiteral(), 0, reconstructedValue, offset, len);
            } else {
                len = instruction.getReference() == numberOfBlocks - 1 ? lastBlockSize : blockSize;
                int reference = instruction.getReference();
                System.arraycopy(oldValue, reference * blockSize, reconstructedValue, offset, len);
            }
            offset += len;
        }
        return reconstructedValue;
    }

    public static byte[] intToByteArray(int value) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(value >>> offset & 0xFF);
        }
        return b;
    }

    public static int byteArrayToInt(byte[] b) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (b[i] & 0xFF) << shift;
        }
        return value;
    }

    public static byte[] encodeChecksumList(ArrayList<Checksum> checksums) {
        int size = checksums.size();
        byte[] array = new byte[4 + size * 20];
        byte[] info = Synchronization.intToByteArray(size);
        System.arraycopy(info, 0, array, 0, 4);
        for (int i = 0; i < size; ++i) {
            byte[] weakChecksum = Synchronization.intToByteArray(checksums.get(i).getWeakChecksum());
            System.arraycopy(weakChecksum, 0, array, 20 * i + 4, 4);
            System.arraycopy(checksums.get(i).getStrongChecksum(), 0, array, 20 * i + 8, 16);
        }
        return array;
    }

    public static ArrayList<Checksum> decodeChecksumList(byte[] bytes) {
        ArrayList<Checksum> checksums = new ArrayList<Checksum>();
        byte[] info = new byte[4];
        System.arraycopy(bytes, 0, info, 0, 4);
        int size = Synchronization.byteArrayToInt(info);
        for (int i = 0; i < size; ++i) {
            Checksum checksum = new Checksum();
            byte[] weakChecksum = new byte[4];
            System.arraycopy(bytes, 20 * i + 4, weakChecksum, 0, 4);
            checksum.setWeakChecksum(Synchronization.byteArrayToInt(weakChecksum));
            byte[] strongChecksum = new byte[16];
            System.arraycopy(bytes, 20 * i + 8, strongChecksum, 0, 16);
            checksum.setStrongChecksum(strongChecksum);
            checksums.add(checksum);
        }
        return checksums;
    }

    public static byte[] encodeInstructionList(ArrayList<Instruction> instructions, Number160 number160) {
        int size = instructions.size();
        int length = 0;
        ArrayList<Integer> literalSize = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            int temp = instructions.get(i).literalSize();
            length += temp;
            literalSize.add(temp);
        }
        byte[] array = new byte[24 + 8 * size + length];
        byte[] hash = number160.toByteArray();
        System.arraycopy(hash, 0, array, 0, 20);
        byte[] info = Synchronization.intToByteArray(size);
        System.arraycopy(info, 0, array, 20, 4);
        for (int i = 0; i < size; ++i) {
            System.arraycopy(Synchronization.intToByteArray((Integer)literalSize.get(i)), 0, array, 4 * i + 24, 4);
        }
        int nextPosition = 4 * size + 24;
        int shift = 0;
        for (int i = 0; i < size; ++i) {
            byte[] reference = Synchronization.intToByteArray(instructions.get(i).getReference());
            System.arraycopy(reference, 0, array, nextPosition + shift, 4);
            if ((Integer)literalSize.get(i) != 0) {
                System.arraycopy(instructions.get(i).getLiteral(), 0, array, nextPosition + shift + 4, (Integer)literalSize.get(i));
            }
            shift += (Integer)literalSize.get(i) + 4;
        }
        return array;
    }

    public static ArrayList<Instruction> decodeInstructionList(byte[] bytes) {
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        byte[] info = new byte[4];
        System.arraycopy(bytes, 20, info, 0, 4);
        int size = Synchronization.byteArrayToInt(info);
        ArrayList<Integer> literalSize = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            byte[] temp = new byte[4];
            System.arraycopy(bytes, 4 * i + 24, temp, 0, 4);
            literalSize.add(Synchronization.byteArrayToInt(temp));
        }
        int nextPosition = 4 * size + 24;
        int shift = 0;
        for (int i = 0; i < size; ++i) {
            Instruction instruction = new Instruction();
            byte[] reference = new byte[4];
            System.arraycopy(bytes, nextPosition + shift, reference, 0, 4);
            int referenceValue = Synchronization.byteArrayToInt(reference);
            if (referenceValue != -1) {
                instruction.setReference(referenceValue);
            } else {
                byte[] literal = new byte[((Integer)literalSize.get(i)).intValue()];
                System.arraycopy(bytes, nextPosition + shift + 4, literal, 0, (Integer)literalSize.get(i));
                instruction.setLiteral(literal);
            }
            shift += (Integer)literalSize.get(i) + 4;
            instructions.add(instruction);
        }
        return instructions;
    }

    public static Number160 decodeHash(byte[] bytes) {
        byte[] number160 = new byte[20];
        System.arraycopy(bytes, 0, number160, 0, 20);
        return new Number160(number160);
    }
}

