/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.replication;

import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.ResponsibilityListener;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.PeerExchangeRPC;
import net.tomp2p.storage.TrackerStorage;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerStorageReplication
implements ResponsibilityListener {
    private static final Logger LOG = LoggerFactory.getLogger(TrackerStorageReplication.class);
    private final PeerExchangeRPC peerExchangeRPC;
    private final TrackerStorage trackerStorage;
    private final Peer peer;

    public TrackerStorageReplication(Peer peer, PeerExchangeRPC peerExchangeRPC, TrackerStorage trackerStorage) {
        this.peer = peer;
        this.peerExchangeRPC = peerExchangeRPC;
        this.trackerStorage = trackerStorage;
    }

    public void meResponsible(Number160 locationKey) {
    }

    public void otherResponsible(final Number160 locationKey, final PeerAddress other, boolean delayed) {
        LOG.debug("other peer became responsibel and we thought we were responsible, so move the data to this peer");
        for (final Number160 domainKey : this.trackerStorage.responsibleDomains(locationKey)) {
            FutureChannelCreator futureChannelCreator = this.peer.getConnectionBean().reservation().create(1, 0);
            futureChannelCreator.addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        FutureResponse futureResponse = TrackerStorageReplication.this.peerExchangeRPC.peerExchange(other, locationKey, domainKey, true, future.getChannelCreator(), (ConnectionConfiguration)new DefaultConnectionConfiguration());
                        Utils.addReleaseListener((ChannelCreator)future.getChannelCreator(), (BaseFuture[])new BaseFuture[]{futureResponse});
                        TrackerStorageReplication.this.peer.notifyAutomaticFutures((BaseFuture)futureResponse);
                    } else {
                        LOG.error("otherResponsible failed {}", (Object)future.getFailedReason());
                    }
                }
            });
        }
    }
}

