/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.io.File;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.Number640;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.DataSerializer;
import net.tomp2p.storage.Storage;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;

public class StorageDisk
implements Storage {
    private final NavigableMap<Number640, Data> dataMap;
    private final Map<Number640, Long> timeoutMap;
    private final ConcurrentNavigableMap<Long, Set<Number640>> timeoutMapRev;
    private final Map<Number320, PublicKey> protectedDomainMap;
    private final Map<Number480, PublicKey> protectedEntryMap;
    private final Map<Number160, Number160> responsibilityMap;
    private final Map<Number160, Set<Number160>> responsibilityMapRev;
    private final DB db;

    public StorageDisk(DB db, Number160 peerId, File path) {
        this.db = db;
        DataSerializer dataSerializer = new DataSerializer(path);
        this.dataMap = db.createTreeMap("dataMap_" + peerId.toString()).valueSerializer((Serializer)dataSerializer).make();
        this.timeoutMap = db.createTreeMap("timeoutMap_" + peerId.toString()).valueSerializer((Serializer)dataSerializer).make();
        this.timeoutMapRev = db.createTreeMap("timeoutMapRev_" + peerId.toString()).valueSerializer((Serializer)dataSerializer).make();
        this.protectedDomainMap = db.createTreeMap("protectedDomainMap_" + peerId.toString()).valueSerializer((Serializer)dataSerializer).make();
        this.protectedEntryMap = db.createTreeMap("protectedEntryMap_" + peerId.toString()).valueSerializer((Serializer)dataSerializer).make();
        this.responsibilityMap = db.createTreeMap("responsibilityMap_" + peerId.toString()).valueSerializer((Serializer)dataSerializer).make();
        this.responsibilityMapRev = db.createTreeMap("responsibilityMapRev_" + peerId.toString()).valueSerializer((Serializer)dataSerializer).make();
    }

    public StorageDisk(File path, Number160 peerId) {
        this(DBMaker.newFileDB((File)new File(path, "tomp2p")).transactionDisable().closeOnJvmShutdown().make(), peerId, path);
    }

    public boolean put(Number640 key, Data value) {
        this.dataMap.put(key, value);
        this.db.commit();
        return true;
    }

    public Data get(Number640 key) {
        return (Data)this.dataMap.get(key);
    }

    public boolean contains(Number640 key) {
        return this.dataMap.containsKey(key);
    }

    public int contains(Number640 from, Number640 to) {
        NavigableMap<Number640, Data> tmp = this.dataMap.subMap(from, true, to, true);
        return tmp.size();
    }

    public Data remove(Number640 key, boolean returnData) {
        Data retVal = (Data)this.dataMap.remove(key);
        this.db.commit();
        return retVal;
    }

    public NavigableMap<Number640, Data> remove(Number640 from, Number640 to, boolean returnData) {
        NavigableMap<Number640, Data> tmp = this.dataMap.subMap(from, true, to, true);
        TreeMap<Number640, Data> copy = new TreeMap<Number640, Data>((SortedMap<Number640, Data>)tmp);
        tmp.clear();
        this.db.commit();
        return copy;
    }

    public NavigableMap<Number640, Data> subMap(Number640 from, Number640 to, int limit, boolean ascending) {
        NavigableMap<Number640, Data> tmp = this.dataMap.subMap(from, true, to, true);
        if (limit < 0) {
            return new TreeMap<Number640, Data>((SortedMap<Number640, Data>)(ascending ? tmp : tmp.descendingMap()));
        }
        TreeMap<Number640, Data> retVal = new TreeMap<Number640, Data>();
        limit = Math.min(limit, tmp.size());
        Iterator iterator = ascending ? tmp.entrySet().iterator() : tmp.descendingMap().entrySet().iterator();
        for (int i = 0; iterator.hasNext() && i < limit; ++i) {
            Map.Entry entry = iterator.next();
            retVal.put((Number640)entry.getKey(), (Data)entry.getValue());
        }
        return retVal;
    }

    public NavigableMap<Number640, Data> map() {
        return new TreeMap<Number640, Data>((SortedMap<Number640, Data>)this.dataMap);
    }

    public void addTimeout(Number640 key, long expiration) {
        Long oldExpiration = this.timeoutMap.put(key, expiration);
        Set<Number640> tmp = this.putIfAbsent2(expiration, Collections.newSetFromMap(new ConcurrentHashMap()));
        tmp.add(key);
        if (oldExpiration == null) {
            return;
        }
        this.removeRevTimeout(key, oldExpiration);
        this.db.commit();
    }

    public void removeTimeout(Number640 key) {
        Long expiration = this.timeoutMap.remove(key);
        if (expiration == null) {
            return;
        }
        this.removeRevTimeout(key, expiration);
        this.db.commit();
    }

    private void removeRevTimeout(Number640 key, Long expiration) {
        Set tmp = (Set)this.timeoutMapRev.get(expiration);
        if (tmp != null) {
            tmp.remove(key);
            if (tmp.isEmpty()) {
                this.timeoutMapRev.remove(expiration);
            }
        }
    }

    public Collection<Number640> subMapTimeout(long to) {
        SortedMap tmp = this.timeoutMapRev.subMap((Object)0L, (Object)to);
        ArrayList<Number640> toRemove = new ArrayList<Number640>();
        for (Set set : tmp.values()) {
            toRemove.addAll(set);
        }
        return toRemove;
    }

    private Set<Number640> putIfAbsent2(long expiration, Set<Number640> hashSet) {
        Set<Number640> timeouts = this.timeoutMapRev.putIfAbsent(expiration, hashSet);
        return timeouts == null ? hashSet : timeouts;
    }

    public Number160 findPeerIDForResponsibleContent(Number160 locationKey) {
        return this.responsibilityMap.get(locationKey);
    }

    public Collection<Number160> findContentForResponsiblePeerID(Number160 peerID) {
        return this.responsibilityMapRev.get(peerID);
    }

    public boolean updateResponsibilities(Number160 locationKey, Number160 peerId) {
        boolean isNew = true;
        Number160 oldPeerId = this.responsibilityMap.put(locationKey, peerId);
        Set<Number160> contentIDs = this.putIfAbsent1(peerId, new HashSet<Number160>());
        contentIDs.add(locationKey);
        if (oldPeerId != null) {
            boolean bl = isNew = !oldPeerId.equals((Object)peerId);
            if (isNew) {
                this.removeRevResponsibility(oldPeerId, locationKey);
            }
        }
        this.db.commit();
        return isNew;
    }

    private Set<Number160> putIfAbsent1(Number160 peerId, Set<Number160> hashSet) {
        Set<Number160> contentIDs = ((ConcurrentMap)this.responsibilityMapRev).putIfAbsent(peerId, hashSet);
        return contentIDs == null ? hashSet : contentIDs;
    }

    public void removeResponsibility(Number160 locationKey) {
        Number160 peerId = this.responsibilityMap.remove(locationKey);
        if (peerId != null) {
            this.removeRevResponsibility(peerId, locationKey);
            this.db.commit();
        }
    }

    private void removeRevResponsibility(Number160 peerId, Number160 locationKey) {
        Set<Number160> contentIDs = this.responsibilityMapRev.get(peerId);
        if (contentIDs != null) {
            contentIDs.remove(locationKey);
            if (contentIDs.isEmpty()) {
                this.responsibilityMapRev.remove(peerId);
            }
        }
    }

    public void close() {
        this.db.close();
    }

    public boolean protectDomain(Number320 key, PublicKey publicKey) {
        this.protectedDomainMap.put(key, publicKey);
        return true;
    }

    public boolean isDomainProtectedByOthers(Number320 key, PublicKey publicKey) {
        PublicKey other = this.protectedDomainMap.get(key);
        if (other == null) {
            return false;
        }
        return !other.equals(publicKey);
    }

    public boolean protectEntry(Number480 key, PublicKey publicKey) {
        this.protectedEntryMap.put(key, publicKey);
        return true;
    }

    public boolean isEntryProtectedByOthers(Number480 key, PublicKey publicKey) {
        PublicKey other = this.protectedEntryMap.get(key);
        if (other == null) {
            return false;
        }
        return !other.equals(publicKey);
    }
}

